---
generated_at: 2026-01-29 21:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-メンバーラベル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Author以上のロールでの権限**: マイグレーションファイル参照のみで実行時確認なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/label.js` - Labelモデル定義
- E-02: `ghost/core/core/server/api/endpoints/labels.js` - APIエンドポイント
- E-03: `ghost/core/core/server/data/migrations/versions/5.0/2022-05-12-13-51-add-label-permissions-for-authors.js` - 権限マイグレーション
- E-04: `ghost/core/core/server/services/members/importer/labels.js` - CSVインポート用ラベル処理
- E-05: 機能一覧.csv - 機能定義
- E-06: 画面機能マッピング.csv - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名はlabels | E-01 (14行目: `tableName: 'labels'`) | ○ |
| C-02 | メンバーとの多対多リレーション | E-01 (59-61行目: belongsToMany via members_labels) | ○ |
| C-03 | onSavingでスラッグ自動生成 | E-01 (42-57行目) | ○ |
| C-04 | イベント発火(added/edited/deleted) | E-01 (19-40行目: emitChange実装) | ○ |
| C-05 | 削除時に関連を先に解除 | E-01 (107-126行目: destroy内でdetach後delete) | ○ |
| C-06 | browseでfindPage使用 | E-02 (36-38行目) | ○ |
| C-07 | readでfindOne使用 | E-02 (62-63行目) | ○ |
| C-08 | addでモデル追加 | E-02 (90-91行目) | ○ |
| C-09 | ユニーク制約エラーハンドリング | E-02 (92-98行目: catch でunique検出) | ○ |
| C-10 | editでモデル更新 | E-02 (122行目) | ○ |
| C-11 | destroyでモデル削除 | E-02 (156-157行目) | ○ |
| C-12 | メンバー数カウントのサブクエリ | E-01 (93-105行目: countRelations) | ○ |
| C-13 | include: count.members対応 | E-02 (10行目: ALLOWED_INCLUDES) | ○ |
| C-14 | ラベル名トリミング | E-01 (47-48行目) | ○ |
| C-15 | Author以上の権限 | E-03 (マイグレーションファイル名から推測) | △ |
| C-16 | CSVインポート時のラベル自動付与 | E-04 (ファイル存在確認) | ○ |
| C-17 | 関連画面: メンバー一覧・詳細 | E-06 (17, 18行目) | ○ |
| C-18 | 機能カテゴリ: メンバー管理 | E-05 (12行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- Author権限の実行時適用確認
  - 候補：permissionsテーブル / fixtures / テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の主要ロジックはソースコードで確認済み
- 1: 中リスク - 権限設定はマイグレーションファイルのみで確認（実行時動作は未検証）

## 6) レビュアーチェックリスト（最小）
- [ ] labels テーブルのスキーマが設計書と一致するか確認
- [ ] Author ロールでのラベル操作権限を実環境で確認
- [ ] CSVインポート時のラベル自動生成動作を確認
