---
generated_at: 2026-01-29 21:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：12-メンバーCSVインポート・エクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **エクスポートクエリの詳細**: query.jsファイルの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/members/importer/members-csv-importer.js` - CSVインポーター
- E-02: `ghost/core/core/server/api/endpoints/members.js` - APIエンドポイント
- E-03: 機能一覧.csv - 機能定義
- E-04: 画面機能マッピング.csv - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSVヘッダーマッピングのデフォルト定義 | E-01 (19-29行目) | ○ |
| C-02 | prepare()でヘッダーマッピング適用 | E-01 (80-115行目) | ○ |
| C-03 | perform()で行単位処理 | E-01 (122-296行目) | ○ |
| C-04 | 500件判定で同期/非同期分岐 | E-01 (388行目: `job.batches <= 500 && !job.metadata.hasStripeData`) | ○ |
| C-05 | 既存メンバーは更新処理 | E-01 (166-195行目) | ○ |
| C-06 | ラベルは追記（上書きでない） | E-01 (190-191行目) | ○ |
| C-07 | 購読解除済みは再購読させない | E-01 (176-179行目) | ○ |
| C-08 | インポートラベル日時付き | E-02 (419-421行目) | ○ |
| C-09 | 未来日付の補正 | E-01 (149-152行目) | ○ |
| C-10 | stripe_customer_id='auto'でメール検索 | E-01 (219-223行目) | ○ |
| C-11 | 無料メンバーにTier指定不可 | E-01 (255-256行目: `freeMemberNotAllowedImportTier`) | ○ |
| C-12 | doNotRejectOnRollbackオプション | E-01 (142行目) | ○ |
| C-13 | エラーCSV生成 | E-01 (307-337行目: generateErrorCSV) | ○ |
| C-14 | 結果メール送信 | E-01 (351-365行目: sendErrorEmail) | ○ |
| C-15 | バックグラウンドジョブ登録 | E-01 (404-437行目) | ○ |
| C-16 | exportCSVでストリーミング | E-02 (387-389行目: response.stream) | ○ |
| C-17 | note 2000文字制限 | E-01 (315-316行目: エラーメッセージ) | ○ |
| C-18 | Tier名無効時のエラー | E-01 (209-212行目) | ○ |
| C-19 | verificationTriggerのチェック | E-01 (391, 429行目) | ○ |
| C-20 | name/note空の場合既存値保持 | E-01 (182-187行目) | ○ |
| C-21 | 関連画面: メンバー一覧・インポート | E-04 (19, 20行目) | ○ |
| C-22 | エクスポートクエリの詳細 | ファイル存在確認のみ | △ |

## 4) 不足情報（Unknown / Missing）
- エクスポートクエリの詳細SQL構造
  - 候補：`ghost/core/core/server/services/members/exporter/query.js` の詳細解析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インポート処理の主要ロジックは詳細に確認済み
- 1: 中リスク - エクスポートクエリの詳細は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 500件閾値の妥当性を確認
- [ ] Stripeデータありの場合のパフォーマンスを確認
- [ ] エクスポートクエリの出力項目を確認
- [ ] 大量インポート時のメール通知の動作確認
