---
generated_at: 2026-01-29 21:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-メンバーアクティビティ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/members-events/index.js` - サービス初期化
- E-02: `ghost/core/core/server/services/members-events/event-storage.js` - イベント保存
- E-03: `ghost/core/core/server/services/members-events/last-seen-at-updater.js` - 最終閲覧更新
- E-04: `ghost/core/core/server/api/endpoints/members.js` - activityFeed API
- E-05: 機能一覧.csv - 機能定義
- E-06: 画面機能マッピング.csv - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventStorageとLastSeenAtUpdaterの2コンポーネント | E-01 (16-55行目) | ○ |
| C-02 | DomainEventsへのサブスクライブ | E-01 (54-55行目) | ○ |
| C-03 | MemberCreatedEventの保存 | E-02 (25-44行目) | ○ |
| C-04 | SubscriptionCreatedEventの保存 | E-02 (47-67行目) | ○ |
| C-05 | 属性情報（UTM等）の保存 | E-02 (31-43行目, 54-65行目) | ○ |
| C-06 | MemberPageViewEventでlast_seen_at更新 | E-03 (49-56行目) | ○ |
| C-07 | MemberLinkClickEventでlast_seen_at更新 | E-03 (61-68行目) | ○ |
| C-08 | clickTrackingLastSeenAtUpdater設定 | E-03 (59-60行目) | ○ |
| C-09 | MemberCommentEventで両方更新 | E-03 (71-78行目, 173-189行目) | ○ |
| C-10 | EmailOpenedEventでlast_seen_at更新 | E-03 (80-87行目) | ○ |
| C-11 | キャッシュによる日次1回制限 | E-03 (118-122行目) | ○ |
| C-12 | タイムゾーン考慮の日付判定 | E-03 (101-102行目, 133-137行目) | ○ |
| C-13 | FOR UPDATEロック取得 | E-03 (144行目: forUpdate: true) | ○ |
| C-14 | member.editedイベント発火 | E-03 (150行目: events.emit) | ○ |
| C-15 | キャッシュミス時はキャッシュクリア | E-03 (158行目: remove) | ○ |
| C-16 | updateLastSeenAtWithoutKnownLastSeen | E-03 (98-113行目) | ○ |
| C-17 | startOfDayでの日付比較 | E-03 (102行目, 137行目, 146行目) | ○ |
| C-18 | activityFeed APIエンドポイント | E-04 (499-512行目) | ○ |
| C-19 | 関連画面: メンバー詳細・アクティビティ | E-06 (18, 20行目) | ○ |
| C-20 | 機能カテゴリ: メンバー管理 | E-05 (14行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] キャッシュの有効期限・クリアタイミングを確認
- [ ] 高負荷時のパフォーマンスを確認
- [ ] タイムゾーン設定変更時の動作確認
