---
generated_at: 2026-01-29 21:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：14-Stripe連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **MRR計算ロジックの詳細**: 計算ロジックの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/stripe/stripe-service.js` - メインサービス
- E-02: `ghost/core/core/server/services/stripe/webhook-controller.js` - Webhookコントローラ（ファイル存在確認）
- E-03: `ghost/core/core/server/services/stripe/stripe-api.js` - Stripe API（ファイル存在確認）
- E-04: 機能一覧.csv - 機能定義
- E-05: 画面機能マッピング.csv - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StripeAPI, WebhookManager, BillingPortalManager構成 | E-01 (59-77行目) | ○ |
| C-02 | configure()でAPI設定 | E-01 (167-192行目) | ○ |
| C-03 | connect()でLiveモード有効化 | E-01 (141-143行目) | ○ |
| C-04 | disconnect()でデータ削除 | E-01 (145-161行目) | ○ |
| C-05 | StripeLiveEnabledEvent発火 | E-01 (142行目) | ○ |
| C-06 | StripeLiveDisabledEvent発火 | E-01 (160行目) | ○ |
| C-07 | WebhookController初期化 | E-01 (126-131行目) | ○ |
| C-08 | SubscriptionEventService | E-01 (78-82行目) | ○ |
| C-09 | InvoiceEventService | E-01 (84-95行目) | ○ |
| C-10 | CheckoutSessionEventService | E-01 (97-124行目) | ○ |
| C-11 | sendSignupEmail機能 | E-01 (114-123行目) | ○ |
| C-12 | 価格・商品削除（disconnect時） | E-01 (146-154行目) | ○ |
| C-13 | testEnv設定対応 | E-01 (179行目) | ○ |
| C-14 | Webhook登録管理 | E-01 (182-186行目) | ○ |
| C-15 | BillingPortal設定 | E-01 (188-191行目) | ○ |
| C-16 | 関連画面: ティア・寄付・プラン・オファー | E-05 (45, 57, 81, 87行目) | ○ |
| C-17 | 機能カテゴリ: 課金・決済 | E-04 (15行目) | ○ |
| C-18 | MRR計算ロジック | 詳細確認なし | △ |

## 4) 不足情報（Unknown / Missing）
- MRR計算の詳細ロジック
  - 候補：subscription-event-service.js / member-repository.js

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メインサービス構造は確認済み
- 1: 中リスク - 個別Webhookハンドラの詳細は追加確認が必要
- 1: 中リスク - MRR計算ロジックの検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Webhook署名検証の実装を確認
- [ ] MRR計算ロジックを確認
- [ ] テスト/本番環境分離の動作確認
- [ ] disconnect時のデータ削除範囲を確認
