---
generated_at: 2026-01-29 21:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-Tier（プラン）管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/tiers/tier.js` - ドメインモデル
- E-02: `ghost/core/core/server/services/tiers/tiers-api.js` - API層
- E-03: `ghost/core/core/server/models/product.js` - Bookshelfモデル
- E-04: 機能一覧.csv - 機能定義
- E-05: 画面機能マッピング.csv - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 名前191文字以内制限 | E-01 (299-313行目: validateName) | ○ |
| C-02 | スラッグ191文字以内制限 | E-01 (290-297行目: validateSlug) | ○ |
| C-03 | 説明191文字以内制限 | E-01 (327-342行目: validateDescription) | ○ |
| C-04 | visibility: public/none | E-01 (353-360行目: validateVisibility) | ○ |
| C-05 | status: active/archived | E-01 (344-351行目: validateStatus) | ○ |
| C-06 | type: paid/free | E-01 (362-369行目: validateType) | ○ |
| C-07 | 通貨3文字ISO | E-01 (391-411行目: validateCurrency) | ○ |
| C-08 | 価格上限9999999999 | E-01 (435-439行目, 465-469行目) | ○ |
| C-09 | Free Tier作成不可 | E-02 (144-148行目: BadRequestError) | ○ |
| C-10 | 価格デフォルト500/5000 | E-01 (423-424行目, 452-453行目) | ○ |
| C-11 | Free Tierに価格不可 | E-01 (393-398行目, 414-419行目, 444-449行目) | ○ |
| C-12 | 通貨大文字化 | E-01 (410行目: toUpperCase) | ○ |
| C-13 | TierPriceChangeEvent発火 | E-01 (170-172行目) | ○ |
| C-14 | TierCreatedEvent発火 | E-01 (282-284行目) | ○ |
| C-15 | updatePricing()メソッド | E-01 (151-173行目) | ○ |
| C-16 | browse()でgetAll使用 | E-02 (55行目) | ○ |
| C-17 | readDefaultTier()の実装 | E-02 (89-102行目) | ○ |
| C-18 | add()でslugService使用 | E-02 (151行目) | ○ |
| C-19 | 関連画面: ティア設定・サインアップ・プラン選択 | E-05 (45, 79, 81行目) | ○ |
| C-20 | 機能カテゴリ: 課金・決済 | E-04 (16行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Stripe価格との同期動作を確認
- [ ] Free Tierの更新制限を確認
- [ ] Benefits関連の整合性確認
