---
generated_at: 2026-01-29 21:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-オファー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/offers/application/offers-api.js` - API層
- E-02: ドメインモデルファイル群（ファイル存在確認）
- E-03: 機能一覧.csv - 機能定義
- E-04: 画面機能マッピング.csv - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getOffer()でトランザクション使用 | E-01 (40-48行目) | ○ |
| C-02 | createOffer()でUniqueChecker使用 | E-01 (60行目) | ○ |
| C-03 | createOffer()でOffer.create呼び出し | E-01 (61行目) | ○ |
| C-04 | updateOffer()で名前更新 | E-01 (92-95行目) | ○ |
| C-05 | updateOffer()でコード更新 | E-01 (97-100行目) | ○ |
| C-06 | updateOffer()で表示タイトル更新 | E-01 (102-105行目) | ○ |
| C-07 | updateOffer()でステータス更新 | E-01 (112-115行目) | ○ |
| C-08 | listOffers()でフィルタ対応 | E-01 (130行目) | ○ |
| C-09 | listOffersAvailableToSubscription()実装 | E-01 (146-212行目) | ○ |
| C-10 | Tier・cadenceでフィルタ | E-01 (169行目) | ○ |
| C-11 | redemptionTypeでフィルタ | E-01 (182-185行目) | ○ |
| C-12 | トライアルオファー除外 | E-01 (189-193行目) | ○ |
| C-13 | 適用済みオファー除外 | E-01 (197-206行目) | ○ |
| C-14 | ensureOfferForStripeCoupon()実装 | E-01 (229-270行目) | ○ |
| C-15 | 重複エラーハンドリング | E-01 (244-260行目) | ○ |
| C-16 | OfferMapper.toDTO使用 | E-01 (47, 65, 119, 134行目) | ○ |
| C-17 | 関連画面: オファー設定・オファーページ | E-04 (56, 87行目) | ○ |
| C-18 | 機能カテゴリ: 課金・決済 | E-03 (17行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ドメインモデルのバリデーションロジックを確認
- [ ] Stripeクーポン連携の動作確認
- [ ] リテンションオファーの適用条件確認
