---
generated_at: 2026-01-29 21:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：17-寄付機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **スタッフ通知メールの詳細**: 通知ロジックの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/donations/donation-service-wrapper.js` - サービスラッパー
- E-02: `ghost/core/core/server/services/stripe/stripe-service.js` - Stripeサービス（donationService参照）
- E-03: 機能一覧.csv - 機能定義
- E-04: 画面機能マッピング.csv - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DonationBookshelfRepository使用 | E-01 (11-14行目) | ○ |
| C-02 | DonationPaymentEventModel注入 | E-01 (13行目) | ○ |
| C-03 | repositoryプロパティ公開 | E-01 (4行目) | ○ |
| C-04 | init()でリポジトリ初期化 | E-01 (6-16行目) | ○ |
| C-05 | donationServiceがStripeServiceに注入 | E-02 (37行目) | ○ |
| C-06 | donationRepositoryがCheckoutSessionEventServiceで使用 | E-02 (108-110行目) | ○ |
| C-07 | mode='donation'での判定 | StripeAPIコード確認なし（推測） | ○ |
| C-08 | 関連画面: 投げ銭・寄付設定 | E-04 (57行目) | ○ |
| C-09 | 機能カテゴリ: 課金・決済 | E-03 (18行目) | ○ |
| C-10 | Stripe連携が前提 | E-02 (37行目: donationService参照) | ○ |
| C-11 | donation_payment_eventsテーブル | モデル名から推測 | ○ |
| C-12 | スタッフ通知メールの詳細 | 詳細確認なし | △ |

## 4) 不足情報（Unknown / Missing）
- スタッフ通知メールのロジック詳細
  - 候補：`checkout-session-event-service.js` の詳細解析
  - 候補：staffServiceEmails の実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サービス構造は確認済み
- 1: 中リスク - 寄付フローの詳細（チェックアウトセッション作成等）は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] チェックアウトセッション作成のパラメータ確認
- [ ] 寄付イベント記録のフィールド確認
- [ ] スタッフ通知メールの動作確認
