---
generated_at: 2026-01-29 21:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-サブスクリプション管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/models/stripe-customer-subscription.js` - モデル定義
- E-02: `ghost/core/core/server/api/endpoints/members.js` - APIエンドポイント
- E-03: 機能一覧.csv - 機能定義
- E-04: 画面機能マッピング.csv - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名 members_stripe_customers_subscriptions | E-01 (5行目) | ○ |
| C-02 | デフォルトMRR: 0 | E-01 (7-9行目) | ○ |
| C-03 | customerリレーション | E-01 (11-13行目) | ○ |
| C-04 | stripePriceリレーション | E-01 (15-17行目) | ○ |
| C-05 | serialize()でJSON形式定義 | E-01 (19-70行目) | ○ |
| C-06 | upsert()静的メソッド | E-01 (74-83行目) | ○ |
| C-07 | editSubscription API | E-02 (178-238行目) | ○ |
| C-08 | status=canceled で即時キャンセル | E-02 (213-219行目) | ○ |
| C-09 | cancel_at_period_end で期末キャンセル | E-02 (221-226行目) | ○ |
| C-10 | createSubscription API | E-02 (240-282行目) | ○ |
| C-11 | stripe_price_id 必須 | E-02 (258-260行目) | ○ |
| C-12 | subscription_id 必須 | E-02 (196-199行目) | ○ |
| C-13 | cancel_at_period_end 必須 | E-02 (201-204行目) | ○ |
| C-14 | status values: canceled | E-02 (205行目) | ○ |
| C-15 | 関連画面: メンバー詳細・アカウントホーム | E-04 (18, 80行目) | ○ |
| C-16 | 機能カテゴリ: 課金・決済 | E-03 (19行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Stripe APIとの整合性確認
- [ ] MRR計算ロジックの詳細確認
- [ ] Webhook経由の更新動作確認
