---
generated_at: 2026-01-29 21:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-ニュースレター配信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/email-service/email-service.js` - メインサービス
- E-02: `ghost/core/core/server/services/email-service/batch-sending-service.js` - バッチ処理
- E-03: 機能一覧.csv - 機能定義
- E-04: 画面機能マッピング.csv - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | checkLimits()で制限チェック | E-01 (84-102行目) | ○ |
| C-02 | checkCanSendEmail()で事前チェック | E-01 (113-132行目) | ○ |
| C-03 | createEmail()でレコード作成 | E-01 (139-184行目) | ○ |
| C-04 | archivedニュースレター拒否 | E-01 (120-124行目) | ○ |
| C-05 | retryEmail()でリトライ | E-01 (186-205行目) | ○ |
| C-06 | previewEmail()でプレビュー | E-01 (297-308行目) | ○ |
| C-07 | sendTestEmail()でテスト送信 | E-01 (317-334行目) | ○ |
| C-08 | scheduleEmail()でジョブ登録 | E-02 (122-129行目) | ○ |
| C-09 | emailJob()でジョブ実行 | E-02 (135-192行目) | ○ |
| C-10 | updateStatusLockでロック取得 | E-02 (142-151行目) | ○ |
| C-11 | createBatches()でバッチ作成 | E-02 (239-342行目) | ○ |
| C-12 | sendBatches()でバッチ送信 | E-02 (430-480行目) | ○ |
| C-13 | MAX_SENDING_CONCURRENCY=2 | E-02 (12行目) | ○ |
| C-14 | リトライ設定: BEFORE_RETRY_CONFIG | E-02 (39行目) | ○ |
| C-15 | リトライ設定: AFTER_RETRY_CONFIG | E-02 (40行目) | ○ |
| C-16 | リトライ設定: MAILGUN_API_RETRY_CONFIG | E-02 (41行目) | ○ |
| C-17 | ドメインウォーミング対応 | E-02 (242-248行目) | ○ |
| C-18 | 配信時間分散 | E-02 (757-774行目: calculateDeliveryTimes) | ○ |
| C-19 | getBatchMembers()でメンバー取得 | E-02 (610-636行目) | ○ |
| C-20 | ステータス: pending→submitting→submitted/failed | E-02 (144, 165-170行目) | ○ |
| C-21 | 関連画面: エディタ画面 | E-04 (13行目) | ○ |
| C-22 | 機能カテゴリ: メール配信 | E-03 (20行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Mailgun APIエラー時の挙動確認
- [ ] ドメインウォーミングの閾値確認
- [ ] 配信時間分散の計算ロジック確認
