---
generated_at: 2026-01-29 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：2-ページ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：コード内に明示的な定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/api/endpoints/pages.js`
- E-02: `ghost/core/core/server/models/post.js`
- E-03: `ghost/core/core/server/services/posts/posts-service.js`
- E-04: `ghost/core/core/server/data/schema/schema.js`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページはpostsテーブルにtype='page'で保存される | E-04 (73行目) | ○ |
| C-02 | ページのtypeは'post'または'page'のみ許可 | E-04 (73行目) validations.isIn | ○ |
| C-03 | ページAPIはmodels.Postを使用 | E-01 (47行目, 85行目, 121行目) | ○ |
| C-04 | 権限チェックはdocName:'posts'を使用 | E-01 (43-44行目, 80-82行目, 117-118行目) | ○ |
| C-05 | browseアクションでmodels.Post.findPageを使用 | E-01 (47行目) | ○ |
| C-06 | readアクションでmodels.Post.findOneを使用 | E-01 (85行目) | ○ |
| C-07 | addアクションでmodels.Post.addを使用 | E-01 (121行目) | ○ |
| C-08 | editアクションでmodels.Post.editを使用 | E-01 (164行目) | ○ |
| C-09 | destroyアクションでmodels.Post.destroyを使用 | E-01 (252行目) | ○ |
| C-10 | ALLOWED_INCLUDESが定義されている | E-01 (5行目) | ○ |
| C-11 | addアクションは201ステータスを返す | E-01 (97行目) | ○ |
| C-12 | destroyアクションは204ステータスを返す | E-01 (228-229行目) | ○ |
| C-13 | bulkEditアクションが存在 | E-01 (178-209行目) | ○ |
| C-14 | bulkDestroyアクションが存在 | E-01 (211-226行目) | ○ |
| C-15 | copyアクションが存在 | E-01 (256-280行目) | ○ |
| C-16 | copyアクションはpostsService.copyPostを使用 | E-01 (278行目) | ○ |
| C-17 | handleCacheInvalidationが呼び出される | E-01 (166行目) | ○ |
| C-18 | handleCacheInvalidationの実装が存在 | E-03 (422-448行目) | ○ |
| C-19 | ページはニュースレター配信対象外 | E-01（newsletterパラメータなし）, E-03 | ○ |
| C-20 | emitChangeでリソースタイプに応じたイベント名を生成 | E-02 (356-367行目) | ○ |
| C-21 | page.added/page.edited/page.publishedイベントが発行される | E-02 (364行目) resourceType使用 | ○ |
| C-22 | ページは記事と同じスラッグ一意制約 | E-04 (102-104行目) UNIQUE_CONSTRAINTS | ○ |
| C-23 | ページの公開日時制約は記事と同じ | E-02 (590-600行目) | ○ |
| C-24 | ページのContributor制約は記事と同じ | E-02 (1418-1424行目) | ○ |
| C-25 | posts_metaテーブルが関連付けられる | E-01 (5行目) ALLOWED_INCLUDES, E-04 (106-122行目) | ○ |
| C-26 | post_revisionsテーブルが関連付けられる | E-01 (5行目) ALLOWED_INCLUDES | ○ |
| C-27 | トランザクション内で操作される | E-02 (1317-1325行目) | ○ |
| C-28 | パフォーマンス要件（100件500ms以内など） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - コード内には明示的なSLAやパフォーマンス目標の定義が見つからなかった
  - 候補：運用ドキュメント / SLA定義書 / パフォーマンステスト仕様書

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: ページがpostsテーブルを使用する点（コードから明確）
- **0 (低リスク)**: 権限チェックがpostsと同じである点（明示的にdocName:'posts'）
- **0 (低リスク)**: APIエンドポイントの構造（コードから直接抽出）
- **1 (中リスク)**: パフォーマンス要件（推測値の可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] ページがpostsテーブルにtype='page'で保存されることを確認
- [ ] 権限チェックがpostsと同じモデルを使用することを確認
- [ ] ニュースレター配信機能がページには適用されないことを確認
- [ ] 関連画面のマッピングが画面機能マッピング.csvと一致しているか確認
- [ ] パフォーマンス要件の数値が実際の運用基準と一致しているか確認
