---
generated_at: 2026-01-29 22:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-ニュースレター管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/models/newsletter.js` - Bookshelfモデル定義
- E-02: `ghost/core/core/server/services/newsletters/newsletters-service.js` - サービス層
- E-03: `ghost/core/core/server/api/endpoints/newsletters.js` - APIエンドポイント
- E-04: 機能一覧.csv - 機能定義
- E-05: 画面機能マッピング.csv - 画面関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名 newsletters | E-01 (7行目) | ○ |
| C-02 | uuid: crypto.randomUUID() | E-01 (11行目) | ○ |
| C-03 | sender_reply_to デフォルト newsletter | E-01 (12行目) | ○ |
| C-04 | status デフォルト active | E-01 (13行目) | ○ |
| C-05 | visibility デフォルト members | E-01 (14行目) | ○ |
| C-06 | subscribe_on_signup デフォルト true | E-01 (15行目) | ○ |
| C-07 | members() 多対多リレーション | E-01 (43-50行目) | ○ |
| C-08 | posts() 一対多リレーション | E-01 (52-54行目) | ○ |
| C-09 | enforcedFilters() でstatus:active | E-01 (57-59行目) | ○ |
| C-10 | onSaving() でslug自動生成 | E-01 (68-78行目) | ○ |
| C-11 | subscribeMembersById() バッチ登録 | E-01 (81-98行目) | ○ |
| C-12 | countRelations() でcount.posts等 | E-01 (144-172行目) | ○ |
| C-13 | getNextAvailableSortOrder() | E-01 (206-224行目) | ○ |
| C-14 | read() でfindOne | E-02 (100-109行目) | ○ |
| C-15 | browse() でfindPage | E-02 (116-118行目) | ○ |
| C-16 | add() でlimitService.errorIfWouldGoOverLimit | E-02 (143行目) | ○ |
| C-17 | prepAttrsForEmailVerification() | E-02 (265-326行目) | ○ |
| C-18 | opt_in_existing でfetchAllSubscribed | E-02 (175行目) | ○ |
| C-19 | verifyPropertyUpdate() でトークン検証 | E-02 (245-258行目) | ○ |
| C-20 | sender_reply_to newsletter/support は検証不要 | E-02 (273行目) | ○ |
| C-21 | feedback_enabled Labs依存 | E-02 (306-311行目) | ○ |
| C-22 | allowedIncludes count.posts,members,active_members | E-03 (1行目) | ○ |
| C-23 | add API opt_in_existing オプション | E-03 (71行目) | ○ |
| C-24 | 関連画面: ニュースレター設定 | E-05 (47行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] メールアドレス検証フローの動作確認
- [ ] limitServiceのニュースレター数制限値の確認
- [ ] Labs.audienceFeedbackの有効化状況確認
- [ ] MagicLinkトークンの有効期限（24時間）の確認
