---
generated_at: 2026-01-29 21:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：21-メールテンプレート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **レスポンス時間要件（100ms以内）**：根拠不足
  2. **HMACによる署名**：コード確認済みだが詳細検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/email-service/email-renderer.js`
- E-02: `ghost/core/core/server/services/email-service/email-service.js`
- E-03: `ghost/core/core/server/services/email-service/email-templates/template.hbs`
- E-04: `ghost/core/core/server/data/schema/schema.js`
- E-05: `ghost/core/core/server/services/email-service/helpers/register-helpers.js`
- E-06: `機能一覧.csv`
- E-07: `画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレターのデザイン・レイアウトのカスタマイズ機能 | E-01 (121-199行), E-04 (newsletters定義) | ○ |
| C-02 | Lexical/Mobiledocレンダラーによる記事コンテンツ変換 | E-01 (362-373行) | ○ |
| C-03 | メンバー情報に基づく動的プレースホルダー置換 | E-01 (697-848行) | ○ |
| C-04 | Juiceライブラリによるcssインライン化 | E-01 (516-517行) | ○ |
| C-05 | セグメント別コンテンツ処理（Paywall） | E-01 (392-405行) | ○ |
| C-06 | Handlebarsテンプレートエンジンの使用 | E-01 (856-859行), E-03 | ○ |
| C-07 | クリックトラッキング用URLへの変換 | E-01 (438-481行) | ○ |
| C-08 | プレーンテキスト版の自動生成 | E-01 (563行) | ○ |
| C-09 | 開発環境でのアドレス書き換え | E-01 (218-224行) | ○ |
| C-10 | アーカイブ済みニュースレターの配信制限 | E-02 (120-125行) | ○ |
| C-11 | newslettersテーブルのスキーマ定義 | E-04 (12-60行) | ○ |
| C-12 | emailsテーブルのスキーマ定義 | E-04 (826-868行) | ○ |
| C-13 | renderBody()メソッドの処理フロー | E-01 (384-577行) | ○ |
| C-14 | getTemplateData()でのテンプレートデータ構築 | E-01 (1122-1375行) | ○ |
| C-15 | buildReplacementDefinitions()でのプレースホルダー定義 | E-01 (697-848行) | ○ |
| C-16 | Outlook向け特殊文字エスケープ | E-01 (566-570行) | ○ |
| C-17 | figure/figcaption → div 変換 | E-01 (541行) | ○ |
| C-18 | limitImageWidth()での画像処理 | E-01 (1382-1452行) | ○ |
| C-19 | createEmail()でのメール作成処理 | E-02 (139-184行) | ○ |
| C-20 | previewEmail()でのプレビュー生成 | E-02 (297-307行) | ○ |
| C-21 | テンプレートファイル構造（header/content/footer） | E-03 | ○ |
| C-22 | アクセントカラーのコントラスト計算 | E-01 (951-954行) | ○ |
| C-23 | 外部リンクへの rel 属性付与 | E-01 (538行) | ○ |
| C-24 | メンバーuuidのHMAC署名 | E-01 (721-724行) | ○ |
| C-25 | Mailgun連携 | E-06 | ○ |
| C-26 | 関連画面（ニュースレター設定） | E-07 | ○ |
| C-27 | レンダリングのレスポンス時間（100ms以内） | **根拠なし** | △ |
| C-28 | 大量配信時のバッチ処理によるメモリ制御 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **レスポンス時間要件**: パフォーマンス要件についての明確な仕様書やベンチマークテストが確認できず
  - 候補：パフォーマンステスト結果 / SLA仕様書 / 設計仕様書
- **バッチ処理のメモリ制御詳細**: BatchSendingServiceの詳細実装確認が必要
  - 候補：batch-sending-service.js の詳細解析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 1: 中リスク - パフォーマンス要件は実測またはSLA確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] newslettersテーブルのカラムとEmailRendererでの使用箇所が一致しているか確認
- [ ] Handlebarsテンプレートのパーシャル参照がすべて存在するか確認
- [ ] プレースホルダー置換ロジックが正しく動作するか確認
- [ ] パフォーマンス要件（100ms以内）の根拠を追加確認
- [ ] バッチ処理のメモリ制御実装を詳細確認
