---
generated_at: 2026-01-29 21:20:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：22-メール分析

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Prometheusメトリクス監視機能**：コード参照あるが実装詳細の確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/email-analytics/email-analytics-service.js`
- E-02: `ghost/core/core/server/services/email-analytics/email-analytics-provider-mailgun.js`
- E-03: `ghost/core/core/server/services/email-analytics/event-processing-result.js`
- E-04: `ghost/core/core/server/data/schema/schema.js`
- E-05: `機能一覧.csv`
- E-06: `画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Mailgun APIからのイベントデータフェッチ | E-02 (31-44行) | ○ |
| C-02 | イベント種別: delivered, opened, failed, unsubscribed, complained | E-01 (533-618行), E-02 (3行) | ○ |
| C-03 | fetchLatestOpenedEvents()での開封イベント取得 | E-01 (153-163行) | ○ |
| C-04 | fetchLatestNonOpenedEvents()での非開封イベント取得 | E-01 (172-183行) | ○ |
| C-05 | fetchMissing()での欠損イベント取得 | E-01 (191-209行) | ○ |
| C-06 | TRUST_THRESHOLD_MS = 30分 | E-01 (36行) | ○ |
| C-07 | FETCH_LATEST_END_MARGIN_MS = 1分 | E-01 (37行) | ○ |
| C-08 | PAGE_LIMIT = 300 | E-02 (4行) | ○ |
| C-09 | 中間集計間隔: 5分または5000メンバー | E-01 (385行) | ○ |
| C-10 | processEvent()でのイベント種別分岐 | E-01 (533-618行) | ○ |
| C-11 | aggregateStats()での統計集計 | E-01 (625-652行) | ○ |
| C-12 | バッチ処理: 100メンバー/バッチ | E-01 (639行) | ○ |
| C-13 | EventProcessingResultクラスの構造 | E-03 | ○ |
| C-14 | emailsテーブルのdelivered_count, opened_count, failed_count | E-04 (846-848行) | ○ |
| C-15 | membersテーブルのemail_count, email_opened_count, email_open_rate | E-04 (432-434行) | ○ |
| C-16 | email_recipientsテーブルのdelivered_at, opened_at, failed_at | E-04 (895-897行) | ○ |
| C-17 | スケジュール済みフェッチ実行中のValidationError | E-01 (218-222行) | ○ |
| C-18 | フェッチキャンセル処理 | E-01 (241-253行) | ○ |
| C-19 | 開封・非開封の分離処理 | E-01 (63-90行) | ○ |
| C-20 | ジョブ状態管理（jobs テーブル） | E-01 (320行, 456-461行) | ○ |
| C-21 | Prometheusメトリクス対応 | E-01 (111-114行) | ○ |
| C-22 | 関連画面（ニュースレター分析画面） | E-06 | ○ |
| C-23 | 開封率計算ロジック | E-04 (434行), E-01 | ○ |
| C-24 | DEFAULT_TAGS = ['bulk-email'] | E-02 (5行) | ○ |
| C-25 | トラッキングピクセルによる開封追跡 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **トラッキングピクセルの実装詳細**: メール送信時のピクセル埋め込み処理の確認が必要
  - 候補：email-service/sending-service.js / Mailgun設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 0: 低リスク - データベーススキーマとの整合性も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Mailgun APIのイベント種別が網羅されているか確認
- [ ] 集計SQLの正確性を確認（queries.js）
- [ ] ジョブスケジューリングの設定を確認
- [ ] トラッキングピクセルの実装詳細を追加確認
- [ ] Prometheusメトリクスの設定を確認
