---
generated_at: 2026-01-29 21:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：24-メンバー歓迎メール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **automated_email_recipientsへの送信履歴保存**：コードでの実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/member-welcome-emails/service.js`
- E-02: `ghost/core/core/server/services/member-welcome-emails/member-welcome-email-renderer.js`
- E-03: `ghost/core/core/server/data/schema/schema.js`
- E-04: `機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規メンバー登録時の自動歓迎メール送信 | E-01 (52-96行) | ○ |
| C-02 | free/paidそれぞれのテンプレート使用 | E-01 (32-49行) | ○ |
| C-03 | loadMemberWelcomeEmails()でのテンプレート読み込み | E-01 (32-49行) | ○ |
| C-04 | send()でのメール送信処理 | E-01 (52-96行) | ○ |
| C-05 | isMemberWelcomeEmailActive()での有効性確認 | E-01 (98-107行) | ○ |
| C-06 | sendTestEmail()でのテストメール送信 | E-01 (109-150行) | ○ |
| C-07 | #buildReplacementDefinitions()でのプレースホルダー定義 | E-02 (36-49行) | ○ |
| C-08 | #applyReplacements()でのプレースホルダー置換 | E-02 (62-77行) | ○ |
| C-09 | render()でのメインレンダリング | E-02 (88-118行) | ○ |
| C-10 | lexicalLib.render()の使用 | E-02 (91行) | ○ |
| C-11 | Juiceによるcssインライン化 | E-02 (110行) | ○ |
| C-12 | htmlToPlaintext.email()の使用 | E-02 (111行) | ○ |
| C-13 | automated_emailsテーブルのスキーマ | E-03 (1139-1155行) | ○ |
| C-14 | automated_email_recipientsテーブルのスキーマ | E-03 (1156-1165行) | ○ |
| C-15 | テスト用インボックス設定 | E-01 (80-81行) | ○ |
| C-16 | テストメールの[Test]プレフィックス | E-01 (145行) | ○ |
| C-17 | IncorrectUsageError: テンプレートなし | E-01 (59-62行) | ○ |
| C-18 | IncorrectUsageError: 非アクティブ | E-01 (64-68行) | ○ |
| C-19 | ValidationError: lexicalなし | E-01 (119-122行) | ○ |
| C-20 | ValidationError: subjectなし | E-01 (124-127行) | ○ |
| C-21 | NotFoundError: automated_emailなし | E-01 (113-116行) | ○ |
| C-22 | automated_email_recipientsへの送信履歴保存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **送信履歴保存**: service.jsには送信履歴保存のコードが確認できない
  - 候補：別のサービスで実装されている可能性 / 将来実装予定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メインの処理フローは確認済み
- 1: 中リスク - 送信履歴保存の実装有無を確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] slug名 'member-welcome-email-free', 'member-welcome-email-paid' がDBに存在するか確認
- [ ] プレースホルダー置換が正しく動作するか確認
- [ ] テスト用インボックス設定が適切に機能するか確認
- [ ] 送信履歴（automated_email_recipients）への保存実装を確認
