---
generated_at: 2026-01-29 21:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-記事コメント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/comments/comments-service.js`
- E-02: `ghost/core/core/server/models/comment.js`
- E-03: `ghost/core/core/server/models/comment-like.js`
- E-04: `ghost/core/core/server/models/comment-report.js`
- E-05: `ghost/core/core/server/data/schema/schema.js`
- E-06: `機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | comments_enabled設定による機能有効性判定 | E-01 (46-52行) | ○ |
| C-02 | checkEnabled()での'off'時エラー | E-01 (55-61行) | ○ |
| C-03 | checkCommentAccess()でのpaid限定確認 | E-01 (63-70行) | ○ |
| C-04 | checkPostAccess()での記事アクセス権確認 | E-01 (72-80行) | ○ |
| C-05 | commentOnPost()でのコメント投稿 | E-01 (258-306行) | ○ |
| C-06 | replyToComment()での返信投稿 | E-01 (316-394行) | ○ |
| C-07 | 返信への返信禁止（replyToReply） | E-01 (335-339行) | ○ |
| C-08 | editCommentContent()でのコメント編集 | E-01 (429-453行) | ○ |
| C-09 | deleteComment()での論理削除 | E-01 (401-421行) | ○ |
| C-10 | MemberCommentEventのdispatch | E-01 (298-302行, 386-390行) | ○ |
| C-11 | sendNewCommentNotifications()での通知 | E-01 (83-92行) | ○ |
| C-12 | HTMLサニタイズ（p,br,a,blockquote許可） | E-02 (100-115行) | ○ |
| C-13 | trimParagraphs()での空パラグラフ除去 | E-02 (14-22行) | ○ |
| C-14 | リンクへのrel属性強制付与 | E-02 (108-112行) | ○ |
| C-15 | 空コメントのValidationError | E-02 (117-120行) | ○ |
| C-16 | commentsテーブルのスキーマ | E-05 (973-984行) | ○ |
| C-17 | comment_likesテーブルのスキーマ | E-05 (985-991行) | ○ |
| C-18 | comment_reportsテーブルのスキーマ | E-05 (992-998行) | ○ |
| C-19 | status値: published/hidden/deleted | E-05 (979行) | ○ |
| C-20 | 論理削除(softDelete)の実装 | E-02 (152-167行) | ○ |
| C-21 | countRelations()でのreplies/likes/reportsカウント | E-02 (251-296行) | ○ |
| C-22 | likeComment()の実装 | E-01 (94-121行) | ○ |
| C-23 | unlikeComment()の実装 | E-01 (123-144行) | ○ |
| C-24 | reportComment()の実装 | E-01 (146-168行) | ○ |
| C-25 | 所有者以外の編集禁止 | E-01 (437-441行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLサニタイズのルールが適切か確認（XSS対策）
- [ ] 返信への返信禁止のロジックが正しく動作するか確認
- [ ] 論理削除後のコメント表示制御が適切か確認
- [ ] 有料メンバー限定設定時の動作を確認
