---
generated_at: 2026-01-29 21:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-コメント通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/comments/comments-service.js`
- E-02: `ghost/core/core/server/services/comments/comments-service-emails.js`
- E-03: `機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sendNewCommentNotifications() の呼び出し | E-01 (83-92行) | ○ |
| C-02 | notifyPostAuthors() の呼び出し | E-01 (84行) | ○ |
| C-03 | parent_id 時の notifyParentCommentAuthor() | E-01 (86-88行) | ○ |
| C-04 | in_reply_to_id 時の notifyParentCommentAuthor() | E-01 (89-91行) | ○ |
| C-05 | context.internal 時の通知スキップ | E-01 (294-296行, 382-384行) | ○ |
| C-06 | notifyPostAuthors() の実装 | E-02 (35-78行) | ○ |
| C-07 | Post.findOne() with authors 関連 | E-02 (36行) | ○ |
| C-08 | comment_notifications 設定チェック | E-02 (40-42行) | ○ |
| C-09 | notifyParentCommentAuthor() の実装 | E-02 (80-139行) | ○ |
| C-10 | type パラメータ ('parent' / 'in_reply_to') | E-02 (80, 82-86行) | ○ |
| C-11 | status === 'published' チェック | E-02 (89行) | ○ |
| C-12 | enable_comment_notifications チェック | E-02 (89行) | ○ |
| C-13 | 自己返信の除外 | E-02 (96-98行) | ○ |
| C-14 | getPostUrl() のコメントパーマリンク対応 | E-02 (27-33行) | ○ |
| C-15 | labs.isSet('commentPermalinks') チェック | E-02 (29行) | ○ |
| C-16 | extractInitials() の実装 | E-02 (208-212行) | ○ |
| C-17 | sendMail() の実装 | E-02 (214-225行) | ○ |
| C-18 | 開発環境でのログ出力 | E-02 (215-217行) | ○ |
| C-19 | forceTextContent: true の設定 | E-02 (221行) | ○ |
| C-20 | profileUrl (購読解除リンク) の生成 | E-02 (125行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] comment_notifications と enable_comment_notifications の設定UIを確認
- [ ] メールテンプレートの多言語対応を確認
- [ ] 自己返信除外のロジックが正しいか確認
- [ ] コメントパーマリンク labs フラグの設定状況を確認
