---
generated_at: 2026-01-29 10:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：3-タグ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：コード内に明示的な定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/tag.js`
- E-02: `ghost/core/core/server/api/endpoints/tags.js`
- E-03: `ghost/core/core/server/data/schema/schema.js`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タグ名は最大191文字 | E-03 (270行目) | ○ |
| C-02 | タグ名にカンマを含めることはできない | E-03 (270行目) validations.matches | ○ |
| C-03 | スラッグは一意制約 | E-03 (271行目) unique: true | ○ |
| C-04 | 説明は最大500文字 | E-03 (272行目) validations.isLength | ○ |
| C-05 | visibilityはpublic/internalの2値 | E-03 (275-280行目) validations.isIn | ○ |
| C-06 | デフォルトvisibilityはpublic | E-01 (20-23行目) defaults | ○ |
| C-07 | #で始まるタグはvisibility=internalになる | E-01 (115-117行目) onSaving | ○ |
| C-08 | スラッグ未指定時はnameから自動生成 | E-01 (119-126行目) onSaving | ○ |
| C-09 | nameのみでslugなしの場合、nameをnameにセット | E-01 (110-112行目) | ○ |
| C-10 | actionsCollectCRUD: trueで監査ログ記録 | E-01 (17行目) | ○ |
| C-11 | tag.added/tag.edited/tag.deletedイベントが発行される | E-01 (78-99行目) emitChange, onCreated, onUpdated, onDestroyed | ○ |
| C-12 | タグ削除時にposts_tagsの紐付けを解除 | E-01 (189-208行目) destroy | ○ |
| C-13 | browseアクションでmodels.Tag.findPageを使用 | E-02 (37行目) | ○ |
| C-14 | readアクションでmodels.Tag.findOneを使用 | E-02 (65行目) | ○ |
| C-15 | addアクションは201ステータスを返す | E-02 (77行目) | ○ |
| C-16 | addアクションでキャッシュ無効化 | E-02 (78-79行目) | ○ |
| C-17 | destroyアクションは204ステータスを返す | E-02 (133行目) | ○ |
| C-18 | destroyアクションでキャッシュ無効化 | E-02 (134-135行目) | ○ |
| C-19 | editアクションは変更時のみキャッシュ無効化 | E-02 (124-126行目) model.wasChanged() | ○ |
| C-20 | ALLOWED_INCLUDESにcount.postsが含まれる | E-02 (5行目) | ○ |
| C-21 | readアクションでid, slug, visibilityで検索可能 | E-02 (51-55行目) data | ○ |
| C-22 | countRelationsでposts数をカウント | E-01 (169-187行目) | ○ |
| C-23 | destroyでrequire: trueを指定 | E-02 (152行目) | ○ |
| C-24 | postsリレーションが定義されている | E-01 (129-131行目) | ○ |
| C-25 | URL変換処理がformatOnWriteで実装 | E-01 (26-56行目) | ○ |
| C-26 | パフォーマンス要件（100件500ms以内など） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - コード内には明示的なSLAやパフォーマンス目標の定義が見つからなかった
  - 候補：運用ドキュメント / SLA定義書 / パフォーマンステスト仕様書

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: タグ名のバリデーションルール（コードから明確）
- **0 (低リスク)**: 内部タグの自動設定ロジック（コードから明確）
- **0 (低リスク)**: APIエンドポイントの構造（コードから直接抽出）
- **0 (低リスク)**: イベント発行の実装（emitChangeメソッドから明確）
- **1 (中リスク)**: パフォーマンス要件（推測値の可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] タグ名のカンマ禁止ルールが正しく実装されているか確認
- [ ] #で始まるタグの内部タグ自動設定が動作するか確認
- [ ] タグ削除時のposts_tags紐付け解除が正しく動作するか確認
- [ ] 関連画面のマッピングが画面機能マッピング.csvと一致しているか確認
- [ ] パフォーマンス要件の数値が実際の運用基準と一致しているか確認
