---
generated_at: 2026-01-29 22:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-テーマ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/themes/index.js`
- E-02: `ghost/core/core/server/services/themes/activate.js`
- E-03: `ghost/core/core/server/services/themes/loader.js`
- E-04: `ghost/core/core/server/services/themes/storage.js`
- E-05: `ghost/core/core/server/services/themes/validate.js`
- E-06: `機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | init() でのテーマ初期化 | E-01 (14-21行) | ○ |
| C-02 | api.setFromZip でのアップロード | E-04 (48-128行) | ○ |
| C-03 | api.activate でのテーマ有効化 | E-02 (46-62行) | ○ |
| C-04 | api.destroy でのテーマ削除 | E-04 (129-153行) | ○ |
| C-05 | api.getZip でのテーマダウンロード | E-04 (35-47行) | ○ |
| C-06 | デフォルトテーマ(casper, source)の上書き禁止 | E-04 (53-57行) | ○ |
| C-07 | デフォルトテーマの削除禁止 | E-04 (130-134行) | ○ |
| C-08 | アクティブテーマの削除禁止 | E-04 (136-140行) | ○ |
| C-09 | gscan.checkZip() でのバリデーション | E-05 (57-62行) | ○ |
| C-10 | gscan.format() でのフォーマット | E-05 (72-75行) | ○ |
| C-11 | canActivate() での有効化可能判定 | E-05 (36-38行) | ○ |
| C-12 | checkSafe() での安全なバリデーション | E-05 (124-142行) | ○ |
| C-13 | 本番環境での警告非表示 | E-05 (79-81行) | ○ |
| C-14 | gscanCacheStore によるキャッシュ | E-05 (30-34行, 84-89行) | ○ |
| C-15 | loadAndActivate() での起動時処理 | E-02 (17-44行) | ○ |
| C-16 | skipBootChecks オプション | E-01 (17行), E-02 (24行) | ○ |
| C-17 | loadAllThemes() での全テーマ読み込み | E-03 (7-11行) | ○ |
| C-18 | loadOneTheme() での単一テーマ読み込み | E-03 (13-17行) | ○ |
| C-19 | バックアップ作成とリストア | E-04 (66-71行, 98-108行) | ○ |
| C-20 | activateFromAPIOverride() でのアクティブテーマ上書き | E-04 (86行) | ○ |
| C-21 | ThemeValidationError の発生 | E-05 (141行, 144-154行) | ○ |
| C-22 | getThemeErrors() でのキャッシュ取得 | E-05 (100-122行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] gscan のバージョン互換性を確認
- [ ] テーマストレージのパス設定を確認
- [ ] バックアップ・リストアの処理が適切か確認
- [ ] GitHubインストーラーの認証設定を確認
