---
generated_at: 2026-01-29 21:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-カスタムテーマ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：Admin以上という記述の直接的な根拠コードが要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/data/schema/schema.js` (945-964行目) - custom_theme_settingsテーブルスキーマ
- E-02: `ghost/core/core/server/models/custom-theme-setting.js` (5-64行目) - Bookshelfモデル
- E-03: `ghost/core/core/shared/custom-theme-settings-cache/custom-theme-settings-service.js` (16-299行目) - サービスクラス
- E-04: `ghost/core/core/shared/custom-theme-settings-cache/custom-theme-settings-cache.js` (1-27行目) - キャッシュ実装
- E-05: `ghost/core/core/server/api/endpoints/custom-theme-settings.js` (4-28行目) - APIエンドポイント
- E-06: `apps/admin-x-framework/src/api/custom-theme-settings.ts` (4-50行目) - フロントエンドAPI定義
- E-07: `apps/admin-x-settings/src/components/settings/site/design-and-branding/theme-settings.tsx` (43-92行目) - UIコンポーネント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 設定タイプはselect/boolean/color/text/imageの5種類 | E-01 (schema.js 954-959行目) | ○ |
| C-02 | テーマアクティベーション時にcustomSettingsをDBに同期 | E-03 (activateTheme 46-84行目) | ○ |
| C-03 | browse APIで設定一覧を取得 | E-05 (browse 7-15行目) | ○ |
| C-04 | edit APIで設定を更新 | E-05 (edit 17-25行目) | ○ |
| C-05 | select型は定義されたoptionsに含まれる値のみ許可 | E-03 (updateSettings 113-118行目) | ○ |
| C-06 | boolean型はtrue/falseのみ許可 | E-03 (updateSettings 120-126行目) | ○ |
| C-07 | color型は#で始まる6桁の16進数形式 | E-03 (updateSettings 127-133行目) | ○ |
| C-08 | 不明な設定キーはValidationErrorを返す | E-03 (updateSettings 102-108行目) | ○ |
| C-09 | 設定の型が変更された場合、既存レコードを削除して新規作成 | E-03 (_syncRepositoryWithTheme 193-200行目) | ○ |
| C-10 | visibility条件を満たさない設定はキャッシュ値がnull | E-03 (_computeCachedSettings 285-298行目) | ○ |
| C-11 | image型の値はURLTransform処理を適用 | E-02 (parse/formatOnWrite メソッド) | ○ |
| C-12 | 設定取得はキャッシュから行う | E-03 (listSettings 89-95行目) | ○ |
| C-13 | テーマ同期時に新規設定を追加 | E-03 (_syncRepositoryWithTheme 213-227行目) | ○ |
| C-14 | テーマ同期時に削除された設定を削除 | E-03 (_syncRepositoryWithTheme 192-200行目) | ○ |
| C-15 | select型で無効なオプションの場合はデフォルト値にリセット | E-03 (_syncRepositoryWithTheme 203-206行目) | ○ |
| C-16 | Ghost公式テーマではフォント設定が非表示になる場合がある | E-07 (71-74行目) | ○ |
| C-17 | 設定グループはhomepage/postなどテーマ開発者が定義可能 | E-06 (group型定義 21行目) | ○ |
| C-18 | 管理者以上のロールのみ設定編集可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18の権限制御について、APIエンドポイントに`permissions: true`の記載はあるが、具体的なロール制限の詳細コードは未確認
  - 候補：`ghost/core/core/server/services/permissions/` / API Framework の permissions 処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定タイプやバリデーションロジックはコードと完全一致
- 0: 低リスク - DB操作の仕様はスキーマ定義と一致
- 1: 中リスク - 権限制御の詳細は実装詳細の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 設定タイプ5種類の記載が正確か確認
- [ ] バリデーションエラーメッセージの記載が実装と一致するか確認
- [ ] 権限制御の具体的な実装を permissions サービスで確認
- [ ] visibility条件のNQL評価ロジックが正確に記載されているか確認
