---
generated_at: 2026-01-29 21:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：32-コードインジェクション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **ghost_head/ghost_footヘルパーの実装詳細**：ヘルパーファイルの直接確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/data/schema/default-settings/default-settings.json` (137-144行目) - codeinjection設定定義
- E-02: `ghost/core/core/server/models/settings.js` (98-193行目) - Settingsモデル
- E-03: `ghost/core/core/server/api/endpoints/settings.js` (24-148行目) - Settings API

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | codeinjection_headとcodeinjection_footの2つの設定項目が存在 | E-01 (137-144行目) | ○ |
| C-02 | デフォルト値は空文字 | E-01 (defaultValue: "") | ○ |
| C-03 | 設定タイプはstring | E-01 (type: "string") | ○ |
| C-04 | settingsテーブルに保存される | E-02 (tableName: 'settings') | ○ |
| C-05 | Settings API editで更新 | E-03 (edit: 124-147行目) | ○ |
| C-06 | Settings API browseで取得 | E-03 (browse: 28-37行目) | ○ |
| C-07 | 更新時にキャッシュ無効化ヘッダーが設定される | E-03 (frame.setHeader 138-139行目) | ○ |
| C-08 | settingsBREADServiceを使用 | E-03 (8行目, 34-36行目) | ○ |
| C-09 | 設定変更時にemitChangeでイベント発火 | E-02 (emitChange 106-109行目) | ○ |
| C-10 | ghost_head/ghost_footヘルパーで出力 | **根拠不足** | △ |
| C-11 | バリデーションは設定されていない | E-01 (validationsキーなし) | ○ |
| C-12 | siteカテゴリに分類される | E-01 ("site"オブジェクト内) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-10のghost_head/ghost_footヘルパーについて、ファイルパスは特定したが直接の実装確認は未実施
  - 候補：`ghost/core/core/frontend/helpers/ghost_head.js` / `ghost/core/core/frontend/helpers/ghost_foot.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定定義とAPIはコードと一致
- 1: 中リスク - ヘルパーの実装詳細は追加確認が必要
- 0: 低リスク - セキュリティに関する注意事項は一般的なベストプラクティスに基づく

## 6) レビュアーチェックリスト（最小）
- [ ] default-settings.jsonのcodeinjection設定定義を確認
- [ ] ghost_head.js/ghost_foot.jsでcodeinjectionの出力処理を確認
- [ ] Settings APIの権限設定を確認
- [ ] settingsキャッシュの更新タイミングを確認
