---
generated_at: 2026-01-29 21:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-カスタムリダイレクト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/custom-redirects/custom-redirects-api.js` (17-23行目) - RedirectConfig型定義
- E-02: `ghost/core/core/server/services/custom-redirects/custom-redirects-api.js` (54-114行目) - parseRedirectsFile関数
- E-03: `ghost/core/core/server/services/custom-redirects/custom-redirects-api.js` (142-172行目) - init関数
- E-04: `ghost/core/core/server/services/custom-redirects/custom-redirects-api.js` (187-204行目) - getRedirectsFilePath関数
- E-05: `ghost/core/core/server/services/custom-redirects/custom-redirects-api.js` (212-239行目) - setFromFilePath関数
- E-06: `ghost/core/core/server/services/custom-redirects/validation.js` (24-54行目) - validate関数
- E-07: `ghost/core/core/server/services/custom-redirects/index.js` (12-38行目) - 初期化処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RedirectConfigはfrom, to, permanentの3フィールド | E-01 (17-23行目) | ○ |
| C-02 | redirects.yamlが優先される | E-04 (187-204行目: yamlPath優先チェック) | ○ |
| C-03 | JSON形式をサポート | E-02 (55-67行目) | ○ |
| C-04 | YAML形式をサポート（301/302セクション） | E-02 (69-111行目) | ○ |
| C-05 | fromは正規表現として解釈される | E-06 (41-50行目: new RegExp) | ○ |
| C-06 | 配列形式のバリデーション | E-06 (25-30行目: _.isArray) | ○ |
| C-07 | from/toの必須チェック | E-06 (32-39行目) | ○ |
| C-08 | 正規表現の有効性チェック | E-06 (41-50行目: try-catch) | ○ |
| C-09 | 起動時にファイル読み込み | E-03 (142-172行目) | ○ |
| C-10 | バックアップファイルの作成 | E-05 (218-226行目: fs.move) | ○ |
| C-11 | DynamicRedirectManagerにルール登録 | E-03 (155-158行目: addRedirect) | ○ |
| C-12 | permanentMaxAge設定 | E-07 (14-15行目: config.get) | ○ |
| C-13 | サブディレクトリURLの処理 | E-07 (16-18行目: getSubdirectoryURL) | ○ |
| C-14 | JSONパースエラー時のBadRequestError | E-02 (61-63行目) | ○ |
| C-15 | YAMLパースエラー時のBadRequestError | E-02 (76-78行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル解析ロジックはコードと完全一致
- 0: 低リスク - バリデーション処理はコードと完全一致
- 0: 低リスク - 初期化処理はコードと完全一致

## 6) レビュアーチェックリスト（最小）
- [ ] parseRedirectsFile関数のJSON/YAML解析ロジックを確認
- [ ] validation.validate関数のチェック項目を確認
- [ ] getRedirectsFilePath関数のファイル優先順位を確認
- [ ] setFromFilePath関数のバックアップ処理を確認
