---
generated_at: 2026-01-29 21:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-ルート設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/route-settings/index.js` (7-52行目) - 初期化処理
- E-02: `ghost/core/core/server/services/route-settings/route-settings.js` (26-168行目) - RouteSettingsクラス
- E-03: `ghost/core/core/server/services/route-settings/settings-loader.js` (28-60行目) - SettingsLoader
- E-04: `ghost/core/core/server/api/endpoints/settings.js` (150-181行目) - upload/download API

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | routes.yamlが存在しない場合デフォルト設定を使用 | E-01 (21-28行目: ensureSettingsFileExists) | ○ |
| C-02 | YAML形式のみサポート | E-03 (parseYaml呼び出し) | ○ |
| C-03 | RouteSettings型はroutes/collections/taxonomies | E-03 (56-60行目: JSDoc) | ○ |
| C-04 | バックアップファイルを作成 | E-02 (51-53行目: createBackupFile) | ○ |
| C-05 | 自動ロールバック機能 | E-02 (141-145行目: bringBackValidRoutes) | ○ |
| C-06 | 起動完了を最大5回確認 | E-02 (120-137行目: tries > 5) | ○ |
| C-07 | URLジェネレーターのリセット | E-02 (98行目: urlService.resetGenerators) | ○ |
| C-08 | フロントエンドの再読み込み | E-02 (109行目: bridge.reloadFrontend) | ○ |
| C-09 | デフォルトハッシュ値の管理 | E-02 (39行目: defaultRoutesSettingHash) | ○ |
| C-10 | MD5ハッシュ計算 | E-02 (153-157行目: crypto.createHash('md5')) | ○ |
| C-11 | Admin API upload処理 | E-04 (150-161行目) | ○ |
| C-12 | Admin API download処理 | E-04 (163-181行目) | ○ |
| C-13 | YAML形式でダウンロード | E-04 (165-169行目: disposition type 'yaml') | ○ |
| C-14 | routes_hashの同期 | E-04 (159-160行目: syncRoutesHash) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 初期化処理はコードと完全一致
- 0: 低リスク - ファイルアップロード処理はコードと完全一致
- 0: 低リスク - ロールバック処理はコードと完全一致

## 6) レビュアーチェックリスト（最小）
- [ ] index.js初期化処理の各クラス生成を確認
- [ ] route-settings.jsのsetFromFilePath処理フローを確認
- [ ] settings-loader.jsのloadSettings処理を確認
- [ ] settings.jsのupload/downloadエンドポイントを確認
