---
generated_at: 2026-01-29 21:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-一般設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/data/schema/default-settings/default-settings.json` - デフォルト設定定義
- E-02: `ghost/core/core/server/models/settings.js` (98-443行目) - Settingsモデル
- E-03: `ghost/core/core/server/api/endpoints/settings.js` (24-184行目) - Settings API

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | titleのデフォルト値は"Ghost" | E-01 (site.title.defaultValue: "Ghost") | ○ |
| C-02 | titleの最大長は150文字 | E-01 (site.title.validations.isLength.max: 150) | ○ |
| C-03 | descriptionの最大長は200文字 | E-01 (site.description.validations.isLength.max: 200) | ○ |
| C-04 | timezoneにはタイムゾーン検証 | E-01 (site.timezone.validations.isTimezone: true) | ○ |
| C-05 | settingsテーブルに保存 | E-02 (tableName: 'settings') | ○ |
| C-06 | emitChangeでイベント発火 | E-02 (106-109行目: emitChange) | ○ |
| C-07 | 画像URLの変換処理 | E-02 (166-170行目: formatOnWrite, 187-189行目: parse) | ○ |
| C-08 | labsバリデーション | E-02 (338-348行目: validators.labs) | ○ |
| C-09 | Stripeキーバリデーション | E-02 (386-441行目: stripe validators) | ○ |
| C-10 | 設定キー空チェック | E-02 (221-223行目: ValidationError) | ○ |
| C-11 | 存在しない設定キーエラー | E-02 (256行目: NotFoundError) | ○ |
| C-12 | populateDefaultsで初期値投入 | E-02 (262-315行目) | ○ |
| C-13 | 動的デフォルト値生成 | E-02 (52-65行目: dynamicDefault) | ○ |
| C-14 | Settings API browse | E-03 (28-37行目) | ○ |
| C-15 | Settings API edit | E-03 (124-148行目) | ○ |
| C-16 | キャッシュ無効化ヘッダー設定 | E-03 (138-139行目: setHeader) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - デフォルト値定義はコードと完全一致
- 0: 低リスク - バリデーションルールはコードと完全一致
- 0: 低リスク - モデル処理はコードと完全一致

## 6) レビュアーチェックリスト（最小）
- [ ] default-settings.jsonの各設定のデフォルト値とバリデーションを確認
- [ ] settings.jsのvalidatorsメソッドを確認
- [ ] settings.jsのparse/formatメソッドでのURL変換を確認
- [ ] settings.js APIのbrowse/editエンドポイントを確認
