---
generated_at: 2026-01-29 21:35:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-ソーシャルメディア連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/data/schema/default-settings/default-settings.json` (145-152行目) - サイトソーシャル設定
- E-02: `ghost/core/core/server/data/schema/schema.js` (135-138行目) - usersテーブルソーシャルカラム
- E-03: `ghost/core/core/server/api/endpoints/users.js` (43-67行目) - キャッシュ無効化対象属性

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サイトfacebookのデフォルトは"ghost" | E-01 (defaultValue: "ghost") | ○ |
| C-02 | サイトtwitterのデフォルトは"@ghost" | E-01 (defaultValue: "@ghost") | ○ |
| C-03 | ユーザーにfacebook, twitterカラムがある | E-02 (135-136行目) | ○ |
| C-04 | ユーザーにthreads, blueskyカラムがある | E-02 (137-138行目) | ○ |
| C-05 | facebookの最大長は2000文字 | E-02 (maxlength: 2000) | ○ |
| C-06 | threadsの最大長は191文字 | E-02 (maxlength: 191) | ○ |
| C-07 | ソーシャル設定変更でキャッシュ無効化 | E-03 (publicAttrs配列) | ○ |
| C-08 | publicAttrsにfacebookが含まれる | E-03 (54行目) | ○ |
| C-09 | publicAttrsにtwitterが含まれる | E-03 (55行目) | ○ |
| C-10 | publicAttrsにthreads, bluesky等が含まれる | E-03 (59-62行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - デフォルト値はコードと完全一致
- 0: 低リスク - スキーマ定義はコードと完全一致
- 0: 低リスク - キャッシュ無効化ロジックはコードと完全一致

## 6) レビュアーチェックリスト（最小）
- [ ] default-settings.jsonのfacebook, twitter設定を確認
- [ ] schema.jsのusersテーブルソーシャルカラム定義を確認
- [ ] users.jsのpublicAttrs配列を確認
