---
generated_at: 2026-01-29 21:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-多言語対応（i18n）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/i18n/lib/locale-data.json` (1-64行目) - サポート言語リスト
- E-02: `ghost/i18n/lib/i18n.js` (1-155行目) - i18nモジュール
- E-03: `ghost/core/core/server/data/schema/default-settings/default-settings.json` (122-128行目) - locale設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 64言語をサポート | E-01 (64エントリ) | ○ |
| C-02 | locale-data.jsonにcode/labelがある | E-01 (各エントリの構造) | ○ |
| C-03 | generateResourcesでパッケージ翻訳を生成 | E-02 (13-31行目) | ○ |
| C-04 | generateThemeResourcesでテーマ翻訳を生成 | E-02 (33-101行目) | ○ |
| C-05 | 英語へのフォールバック | E-02 (135-138行目: fallbackLng) | ○ |
| C-06 | noはnbにフォールバック | E-02 (136行目: no: ['nb', 'en']) | ○ |
| C-07 | 補間はprefix '{', suffix '}' | E-02 (109-112行目: interpolation) | ○ |
| C-08 | テーマ翻訳ではescapeValue: false | E-02 (114行目) | ○ |
| C-09 | returnEmptyString: false | E-02 (132行目) | ○ |
| C-10 | 名前空間でthemeを特別処理 | E-02 (113-122行目: if ns === 'theme') | ○ |
| C-11 | requireキャッシュをクリア | E-02 (65行目: delete require.cache) | ○ |
| C-12 | localeのデフォルト値は"en" | E-03 (defaultValue: "en") | ○ |
| C-13 | localeはvalidations.isEmptyで空チェック | E-03 (validations.isEmpty: false) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - i18n初期化ロジックはコードと完全一致
- 0: 低リスク - フォールバック設定はコードと完全一致
- 0: 低リスク - 翻訳リソース生成はコードと完全一致

## 6) レビュアーチェックリスト（最小）
- [ ] locale-data.jsonのサポート言語数を確認
- [ ] i18n.jsのgenerateResources/generateThemeResources関数を確認
- [ ] i18n.jsの初期化オプション（fallbackLng, interpolation等）を確認
- [ ] default-settings.jsonのlocale設定を確認
