---
generated_at: 2026-01-29 21:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：38-SEO設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **ghost_headヘルパーの詳細実装**：フォールバックロジックの直接確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/data/schema/default-settings/default-settings.json` (161-232行目) - サイトSEO設定
- E-02: `ghost/core/core/server/data/schema/schema.js` (108-116行目) - postsテーブルSEOカラム
- E-03: `ghost/core/core/server/models/settings.js` (166-189行目) - URL変換処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | meta_titleの最大長は300文字 | E-01 (isLength.max: 300) | ○ |
| C-02 | meta_descriptionの最大長は500文字 | E-01 (isLength.max: 500) | ○ |
| C-03 | og_imageの最大長は2000文字 | E-01 (isLength.max: 2000) | ○ |
| C-04 | og_titleの最大長は300文字 | E-01 (isLength.max: 300) | ○ |
| C-05 | twitter_imageの最大長は2000文字 | E-01 (isLength.max: 2000) | ○ |
| C-06 | postsテーブルにog_image, twitter_imageがある | E-02 (109, 112行目) | ○ |
| C-07 | postsテーブルにog_title, twitter_titleがある | E-02 (110, 113行目) | ○ |
| C-08 | formatOnWriteでog_image/twitter_imageをURL変換 | E-03 (166行目) | ○ |
| C-09 | parseでURL変換の逆処理 | E-03 (188行目) | ○ |
| C-10 | デフォルト値はnull | E-01 (defaultValue: null) | ○ |
| C-11 | postsのmeta_title最大長は300文字 | E-02 (115行目: validations) | ○ |
| C-12 | ghost_headでフォールバック処理を行う | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12のghost_headヘルパーについて、フォールバックロジックの直接確認は未実施
  - 候補：`ghost/core/core/frontend/helpers/ghost_head.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定定義はコードと完全一致
- 0: 低リスク - スキーマ定義はコードと完全一致
- 1: 中リスク - ghost_headの詳細実装は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] default-settings.jsonのSEO設定バリデーションを確認
- [ ] schema.jsのpostsテーブルSEOカラム定義を確認
- [ ] settings.jsのURL変換処理を確認
- [ ] ghost_head.jsのフォールバックロジックを確認
