---
generated_at: 2026-01-29 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 13
  claims_without_evidence: 3
confidence_derived: 0.81
---

# 根拠レポート：4-コレクション管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.81**
  - 根拠あり：13 / 16、根拠なし：3
- 優先レビュー（高）
  1. **Admin APIエンドポイントの存在**：専用エンドポイントが見つからなかった
  2. **権限制御の詳細**：権限チェックの実装箇所が未特定
  3. **自動コレクションのフィルタ処理**：実装詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/collection.js`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | collectionsテーブルが存在 | E-01 (5行目) tableName: 'collections' | ○ |
| C-02 | postsとのbelongsToMany関係 | E-01 (97-106行目) posts() | ○ |
| C-03 | collections_postsテーブル経由で関連 | E-01 (100-101行目) | ○ |
| C-04 | sort_orderで並び順管理 | E-01 (29-31行目) updatePivot | ○ |
| C-05 | type='automatic'の場合は並び順更新スキップ | E-01 (16-18行目) | ○ |
| C-06 | feature_imageのURL変換処理 | E-01 (40-45行目) formatOnWrite | ○ |
| C-07 | filterRelationsでpostsのmanyToMany定義 | E-01 (75-85行目) | ○ |
| C-08 | relationshipsにpostsが含まれる | E-01 (57行目) | ○ |
| C-09 | collectionPosts()のhasMany関係 | E-01 (108-111行目) | ○ |
| C-10 | filterExpansionsでposts.idへの展開 | E-01 (68-73行目) | ○ |
| C-11 | permittedAttributesでrelationshipsを追加 | E-01 (87-95行目) | ○ |
| C-12 | parseでfeature_imageのURL変換 | E-01 (47-55行目) | ○ |
| C-13 | relationshipConfig.posts.editable=false | E-01 (59-62行目) | ○ |
| C-14 | 専用Admin APIエンドポイントが存在 | **根拠なし** - 見つからなかった | △ |
| C-15 | 権限制御の実装 | **根拠なし** - モデルレベルでは未確認 | △ |
| C-16 | 自動コレクションのフィルタ処理詳細 | **根拠なし** - 実装詳細未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- **Admin APIエンドポイント**
  - 現時点では /ghost/api/admin/collections/ などの専用エンドポイントが確認できなかった
  - 候補：APIルーティング設定ファイル / 別パッケージでの実装
- **権限制御の実装**
  - モデルレベルでのpermissible実装が見当たらなかった
  - 候補：API層での権限チェック / ミドルウェアでの制御
- **自動コレクションのフィルタ処理**
  - filter条件に基づく記事収集の実装詳細が未確認
  - 候補：サービス層 / @tryghost/collectionsパッケージ

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: モデル定義の基本構造（コードから明確）
- **0 (低リスク)**: テーブル間のリレーション（コードから明確）
- **2 (高リスク)**: APIエンドポイントの有無（実装状況が不明確）
- **2 (高リスク)**: 機能の完成度（比較的新しい機能のため要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] コレクション機能のAdmin APIエンドポイントが存在するか確認
- [ ] @tryghost/collectionsパッケージの存在と役割を確認
- [ ] 自動コレクションのフィルタ処理の実装箇所を特定
- [ ] 権限制御がどのレイヤーで実装されているか確認
- [ ] 機能の完成度と利用可能状況を確認
