---
generated_at: 2026-01-29 21:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-スタッフ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/models/user.js` (14-15行目) - ASSIGNABLE_ROLES定義
- E-02: `ghost/core/core/server/models/user.js` (55-76行目) - defaults定義
- E-03: `ghost/core/core/server/models/user.js` (183-287行目) - onSaving
- E-04: `ghost/core/core/server/models/user.js` (534-619行目) - edit
- E-05: `ghost/core/core/server/models/user.js` (823-975行目) - permissible
- E-06: `ghost/core/core/server/api/endpoints/users.js` (84-294行目) - APIエンドポイント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ASSIGNABLE_ROLESはAdmin/SuperEditor/Editor/Author/Contributor | E-01 (15行目) | ○ |
| C-02 | デフォルトのstatusはactive | E-02 (66行目) | ○ |
| C-03 | デフォルトのvisibilityはpublic | E-02 (65行目) | ○ |
| C-04 | 名前が空の場合ValidationError | E-03 (197-203行目) | ○ |
| C-05 | メール変更時にGravatar取得 | E-03 (207-218行目) | ○ |
| C-06 | スラッグの自動生成 | E-03 (221-234行目) | ○ |
| C-07 | パスワードのハッシュ化 | E-03 (278-283行目) | ○ |
| C-08 | 複数ロールでValidationError | E-04 (539-545行目) | ○ |
| C-09 | 重複メールチェック | E-04 (547-556行目) | ○ |
| C-10 | ロール変更処理 | E-04 (569-614行目) | ○ |
| C-11 | Ownerは削除不可 | E-05 (876-882行目) | ○ |
| C-12 | 自己ステータス変更不可 | E-05 (892-898行目) | ○ |
| C-13 | 自己ロール変更不可 | E-05 (908-912行目) | ○ |
| C-14 | Editor権限でAuthor/Contributor編集可 | E-05 (870-873行目, 885-888行目) | ○ |
| C-15 | Users API browse | E-06 (87-111行目) | ○ |
| C-16 | Users API edit | E-06 (149-184行目) | ○ |
| C-17 | publicAttrs変更でキャッシュ無効化 | E-06 (43-81行目: shouldInvalidateCacheAfterChange) | ○ |
| C-18 | Owner移譲はActive Adminのみ | E-05 (1118-1130行目: transferOwnership) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ロール管理ロジックはコードと完全一致
- 0: 低リスク - 権限チェックロジックはコードと完全一致
- 0: 低リスク - パスワード処理はコードと完全一致

## 6) レビュアーチェックリスト（最小）
- [ ] user.jsのASSIGNABLE_ROLESとデフォルト値を確認
- [ ] user.jsのonSavingメソッドを確認
- [ ] user.jsのpermissibleメソッドを確認
- [ ] users.jsのAPIエンドポイントを確認
