---
generated_at: 2026-01-29 21:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：41-ロール管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（100ms以内）**：具体的な性能要件の根拠不足
  2. **ロール数6種類固定**：fixtures.jsonを直接確認していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/role.js` - Roleモデル定義
- E-02: `ghost/core/core/server/api/endpoints/roles.js` - APIエンドポイント
- E-03: `ghost/core/core/server/data/schema/schema.js` - DBスキーマ定義
- E-04: `ghost/core/core/server/services/permissions/can-this.js` - 権限チェック実装
- E-05: `ghost/core/core/server/services/permissions/providers.js` - 権限データ取得
- E-06: `ghost/core/core/server/models/role-utils.js` - ロール判定ユーティリティ
- E-07: `ghost/core/core/server/services/permissions/parse-context.js` - コンテキスト解析

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rolesテーブルにid, name, description, created_at, updated_atカラムが存在 | E-03 (193-199行目) | ○ |
| C-02 | roles_usersテーブルで多対多関係を管理 | E-03 (200-204行目) | ○ |
| C-03 | permissions_rolesテーブルで権限との関連を管理 | E-03 (219-223行目) | ○ |
| C-04 | browseアクションでRole.findAll()を実行 | E-02 (19-21行目) | ○ |
| C-05 | permissionsオプションで'assign'のみ許可 | E-02 (14-16行目) | ○ |
| C-06 | permissible関数でロール割り当ての権限チェック | E-01 (59-110行目) | ○ |
| C-07 | Ownerはすべてのロールを割り当て可能 | E-01 (84-85行目) | ○ |
| C-08 | Administratorは一部のロールを割り当て可能 | E-01 (86-87行目) | ○ |
| C-09 | Editor/Super EditorはAuthor/Contributorのみ割り当て可能 | E-01 (88-90行目) | ○ |
| C-10 | APIキー経由でOwnerロール割り当て禁止 | E-01 (96-102行目) | ○ |
| C-11 | setIsRoles関数でロール判定を実施 | E-06 (13-35行目) | ○ |
| C-12 | canThis関数で権限チェックを開始 | E-04 (167-170行目) | ○ |
| C-13 | providers.userでユーザー権限を取得 | E-05 (12-56行目) | ○ |
| C-14 | providers.apiKeyでAPIキー権限を取得 | E-05 (58-74行目) | ○ |
| C-15 | parseContextでコンテキスト解析を実施 | E-07 (8-39行目) | ○ |
| C-16 | internalコンテキストでは権限チェックをスキップ | E-04 (40-42行目) | ○ |
| C-17 | ロールにpermissionsとのリレーションが定義されている | E-01 (29-31行目) | ○ |
| C-18 | ロールにusersとのリレーションが定義されている | E-01 (25-27行目) | ○ |
| C-19 | ロールにapi_keysとのリレーションが定義されている | E-01 (33-35行目) | ○ |
| C-20 | ロール名は最大50文字でユニーク制約あり | E-03 (195行目) | ○ |
| C-21 | cacheInvalidate: falseでキャッシュ無効化しない | E-02 (8-9行目) | ○ |
| C-22 | 標準ロール:Owner,Administrator,Super Editor,Editor,Author,Contributor | E-01 (85-89行目) | ○ |
| C-23 | actionsMapでアクションとオブジェクトタイプの対応を管理 | E-04 (6, 117-120行目) | ○ |
| C-24 | ロール一覧取得は100ms以内で完了 | **根拠なし** | △ |
| C-25 | ロール数は6種類で固定 | **根拠なし（fixtures.json未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（100ms以内）の根拠
  - 候補：パフォーマンステスト結果 / SLA文書 / 要件定義書
- 標準ロール数（6種類）の確定情報
  - 候補：fixtures.json / データベース初期化スクリプト / インストールドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データベーススキーマとモデルの整合性は確認済み
- 0: 低リスク - 権限チェックロジックはコードで確認済み
- 1: 中リスク - パフォーマンス要件の根拠がコードから特定できない

## 6) レビュアーチェックリスト（最小）
- [ ] fixtures.jsonで標準ロールの定義を確認
- [ ] パフォーマンス要件の妥当性を確認（実測値との比較）
- [ ] 関連画面（No.36）の画面仕様との整合性を確認
- [ ] ロール階層の権限チェックロジックが正しく記載されているか確認
