---
generated_at: 2026-01-29 21:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：42-権限管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（50ms以内）**：具体的な性能要件の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/models/permission.js` - Permissionモデル定義
- E-02: `ghost/core/core/server/services/permissions/index.js` - 権限サービス初期化
- E-03: `ghost/core/core/server/services/permissions/can-this.js` - 権限チェックコア実装
- E-04: `ghost/core/core/server/services/permissions/parse-context.js` - コンテキスト解析
- E-05: `ghost/core/core/server/services/permissions/providers.js` - 権限データ取得
- E-06: `ghost/core/core/server/services/permissions/actions-map-cache.js` - actionsMapキャッシュ
- E-07: `ghost/core/core/server/data/schema/schema.js` - DBスキーマ定義
- E-08: `ghost/core/core/server/models/role-utils.js` - ロール判定ユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | permissionsテーブルにid,name,object_type,action_type,object_id,created_at,updated_atが存在 | E-07 (205-213行目) | ○ |
| C-02 | permissions_usersテーブルでユーザー個別権限を管理 | E-07 (214-218行目) | ○ |
| C-03 | permissions_rolesテーブルでロールと権限の関連を管理 | E-07 (219-223行目) | ○ |
| C-04 | init関数でPermission.findAllを実行しactionsMapを初期化 | E-02 (8-16行目) | ○ |
| C-05 | canThis関数でCanThisResultインスタンスを生成 | E-03 (167-171行目) | ○ |
| C-06 | parseContext関数でinternal,user,api_key,memberを解析 | E-04 (8-39行目) | ○ |
| C-07 | internalコンテキストの場合parsed.internal=trueを設定 | E-04 (18-21行目) | ○ |
| C-08 | api_key.type=contentの場合はpublic=true | E-04 (28-32行目) | ○ |
| C-09 | providers.userでユーザーとロールの権限を取得 | E-05 (12-56行目) | ○ |
| C-10 | ユーザーステータスがactiveでない場合UnauthorizedError | E-05 (22-24行目) | ○ |
| C-11 | providers.apiKeyでAPIキーの権限を取得 | E-05 (58-74行目) | ○ |
| C-12 | buildObjectTypeHandlersでオブジェクトタイプごとのハンドラ構築 | E-03 (16-107行目) | ○ |
| C-13 | internalコンテキストの場合は即座にresolve | E-03 (40-42行目) | ○ |
| C-14 | checkPermission関数でaction_typeとobject_typeをマッチング | E-03 (60-67行目) | ○ |
| C-15 | Ownerの場合はhasUserPermission=true | E-03 (68-73行目) | ○ |
| C-16 | Staff APIキーの場合はユーザー権限を使用 | E-03 (76-88行目) | ○ |
| C-17 | TargetModel.permissibleによる追加チェック | E-03 (91-95行目) | ○ |
| C-18 | Permissionモデルのテーブル名はpermissions | E-01 (8行目) | ○ |
| C-19 | PermissionはRoleとbelongsToMany関係 | E-01 (30-32行目) | ○ |
| C-20 | PermissionはUserとbelongsToMany関係 | E-01 (34-36行目) | ○ |
| C-21 | actionsMapはアクションとオブジェクトタイプの対応を管理 | E-06 (10-37行目) | ○ |
| C-22 | actionsMapが空の場合はエラーをスロー | E-03 (117-120行目) | ○ |
| C-23 | setIsRolesでロール判定を実施 | E-08 (13-35行目) | ○ |
| C-24 | objectTypeModelMapで8種類のモデルをマッピング | E-03 (17-26行目) | ○ |
| C-25 | 権限マッチ後、両方の権限がOKならresolve | E-03 (97-99行目) | ○ |
| C-26 | 権限がない場合はNoPermissionErrorをreject | E-03 (101行目) | ○ |
| C-27 | ユーザー検索時withRelatedで権限とロールを取得 | E-05 (13行目) | ○ |
| C-28 | 権限チェックは50ms以内で完了 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（50ms以内）の根拠
  - 候補：パフォーマンステスト結果 / ベンチマーク / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 権限チェックロジックはソースコードで詳細に確認済み
- 0: 低リスク - コンテキスト解析のロジックは明確
- 0: 低リスク - DBスキーマとモデルの整合性確認済み
- 1: 中リスク - パフォーマンス要件の具体的根拠がない

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の妥当性を確認
- [ ] Staff APIキーの権限処理が正しく記載されているか確認
- [ ] モデル固有のpermissible実装をすべて確認
- [ ] 全APIエンドポイントで権限チェックが適用されているか確認
