---
generated_at: 2026-01-29 21:40:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：43-招待機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **メールテンプレートファイルの存在確認**：invite-user.hbsの実在確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/models/invite.js` - Inviteモデル定義
- E-02: `ghost/core/core/server/api/endpoints/invites.js` - APIエンドポイント
- E-03: `ghost/core/core/server/services/invites/invites.js` - 招待サービス
- E-04: `ghost/core/core/server/models/role-utils.js` - ロール判定ユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Inviteモデルのテーブル名はinvites | E-01 (22行目) | ○ |
| C-02 | toJSON関数でtokenを除外 | E-01 (28-33行目) | ○ |
| C-03 | add関数で有効期限を1週間に設定 | E-01 (47行目) | ○ |
| C-04 | security.tokens.generateFromEmailでトークン生成 | E-01 (48-52行目) | ○ |
| C-05 | db_hashをシークレットとして使用 | E-01 (51行目) | ○ |
| C-06 | add以外のアクションはhasUserPermission && hasApiKeyPermissionでチェック | E-01 (60-68行目) | ○ |
| C-07 | Ownerへの招待は禁止 | E-01 (80-84行目) | ○ |
| C-08 | Contributor以外はスタッフ制限チェック対象 | E-01 (86-90行目) | ○ |
| C-09 | Owner/Adminは広範囲のロールを招待可能 | E-01 (95-96行目) | ○ |
| C-10 | Editor/Super EditorはAuthor/Contributorのみ招待可能 | E-01 (97-98行目) | ○ |
| C-11 | APIキー経由ではOwner招待不可かつ制限あり | E-01 (100-101行目) | ○ |
| C-12 | browseアクションでfindPageを使用 | E-02 (36-38行目) | ○ |
| C-13 | destroyアクションでrequire: trueを使用 | E-02 (85-87行目) | ○ |
| C-14 | addアクションでrole_idとemailが必須 | E-02 (103-110行目) | ○ |
| C-15 | unsafeAttrsにrole_idを指定 | E-02 (7, 112-114行目) | ○ |
| C-16 | addアクションでinvites.addサービスを呼び出し | E-02 (116-126行目) | ○ |
| C-17 | 既存招待を検索して削除 | E-03 (26-33行目) | ○ |
| C-18 | InviteModel.addで招待を作成 | E-03 (34-36行目) | ○ |
| C-19 | security.url.encodeBase64でトークンをエンコード | E-03 (47行目) | ○ |
| C-20 | 招待者の名前有無でテンプレートを分岐 | E-03 (42-61行目) | ○ |
| C-21 | api.mail.sendでメール送信 | E-03 (82行目) | ○ |
| C-22 | メール送信成功後にstatus='sent'に更新 | E-03 (84-91行目) | ○ |
| C-23 | エラー時はEmailErrorとしてログ記録 | E-03 (92-103行目) | ○ |
| C-24 | actionsCollectCRUD: trueで操作履歴を記録 | E-01 (24行目) | ○ |
| C-25 | actionsExtraContextでstatusとrole_idを記録 | E-01 (26行目) | ○ |
| C-26 | internalコンテキストではstatus設定をスキップ | E-01 (43-45行目) | ○ |
| C-27 | setIsRolesでOwner/Admin/Editor判定 | E-04 (13-35行目) | ○ |
| C-28 | 招待メールのsubjectにはブログ名と招待者名を含む | E-03 (69-74行目) | ○ |
| C-29 | status初期値はpending | E-01 (44行目) | ○ |
| C-30 | 招待メールテンプレートはinvite-userまたはinvite-user-by-api-key | **根拠なし（テンプレートファイル未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- 招待メールテンプレートファイルの実在確認
  - 候補：`ghost/core/core/server/views/emails/invite-user.hbs`
  - 候補：`ghost/core/core/server/views/emails/invite-user-by-api-key.hbs`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 権限チェックロジックはソースコードで確認済み
- 0: 低リスク - トークン生成・メール送信フローは明確
- 0: 低リスク - ロール階層制限の実装を確認済み
- 1: 中リスク - メールテンプレートファイルの存在確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 招待メールテンプレートファイルの存在を確認
- [ ] スタッフ制限（limitService）の動作を確認
- [ ] 招待トークンの有効期限チェック処理を確認（使用時）
- [ ] 関連画面（No.3 サインアップ画面）との整合性を確認
