---
generated_at: 2026-01-29 21:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：44-Content API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（200ms/100ms）**：具体的な性能要件の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/posts-public.js` - 記事取得APIの実装
- E-02: `ghost/core/core/server/api/endpoints/search-index-public.js` - 検索インデックスAPI
- E-03: Content APIエンドポイント一覧（Glob結果）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | allowedIncludesにtags,authors,tiers,sentimentが含まれる | E-01 (9行目) | ○ |
| C-02 | rejectPrivateFieldsTransformerでpassword/emailを除外 | E-01 (15-24行目) | ○ |
| C-03 | authors.passwordで始まるキーを除外 | E-01 (17行目) | ○ |
| C-04 | authors.emailで始まるキーを除外 | E-01 (17行目) | ○ |
| C-05 | generateOptionsDataでキャッシュキー生成用データを準備 | E-01 (32-49行目) | ○ |
| C-06 | generateAuthDataでメンバー認証情報を取得 | E-01 (51-60行目) | ○ |
| C-07 | browseアクションでcache設定あり | E-01 (70行目) | ○ |
| C-08 | generateCacheKeyDataでキャッシュキーを生成 | E-01 (71-86行目) | ○ |
| C-09 | include,filter,formats,limit,order,pageオプションをサポート | E-01 (88-99行目) | ○ |
| C-10 | postsService.browsePostsでデータ取得 | E-01 (116-117行目) | ○ |
| C-11 | mongoTransformerでプライバシーフィルタを適用 | E-01 (113-115行目) | ○ |
| C-12 | readアクションでPost.findOneを使用 | E-01 (170行目) | ○ |
| C-13 | 404 NotFoundErrorを返す場合がある | E-01 (171-175行目) | ○ |
| C-14 | cacheInvalidate: falseでキャッシュ無効化しない | E-01 (68-69行目) | ○ |
| C-15 | permissions: trueで権限チェック有効 | E-01 (110行目) | ○ |
| C-16 | readアクションでid,slug,uuidをサポート | E-01 (149-153行目) | ○ |
| C-17 | absolute_urlsオプションをサポート | E-01 (97, 147行目) | ○ |
| C-18 | collectionオプションをサポート | E-01 (82, 98行目) | ○ |
| C-19 | メンバーのproductsからtiersを取得 | E-01 (55-57行目) | ○ |
| C-20 | メンバーのstatusがfreeかどうかを判定 | E-01 (54行目) | ○ |
| C-21 | search-index-public.jsが存在する | E-03 (Glob結果) | ○ |
| C-22 | 10種類のpublicエンドポイントが存在する | E-03 (Glob結果: 10ファイル) | ○ |
| C-23 | Post.allowedFormatsでフォーマットをバリデーション | E-01 (106-107, 159-161行目) | ○ |
| C-24 | debugオプションをサポート | E-01 (96, 146行目) | ○ |
| C-25 | 一覧取得は200ms以内、個別取得は100ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な根拠
  - 候補：パフォーマンステスト結果 / SLA文書 / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プライバシーフィルタリングの実装を確認済み
- 0: 低リスク - キャッシュ機構の実装を確認済み
- 0: 低リスク - 10種類のContent APIエンドポイントを確認済み
- 1: 中リスク - パフォーマンス要件の根拠がない

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の妥当性を確認
- [ ] すべてのpublicエンドポイントでpermissions: trueが設定されているか確認
- [ ] プライバシーフィルタがすべてのエンドポイントで適用されているか確認
- [ ] メンバー認証との連携が正しく記載されているか確認
