---
generated_at: 2026-01-29 21:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：45-Admin API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（500ms/1000ms）**：具体的な性能要件の根拠不足
  2. **エンドポイント数60以上**：正確な数の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/` - エンドポイントディレクトリ（Glob結果で66ファイル確認）
- E-02: `ghost/core/core/server/api/endpoints/posts.js` - 記事管理API（参照）
- E-03: `ghost/core/core/server/api/endpoints/integrations.js` - インテグレーションAPI
- E-04: `ghost/core/core/server/api/endpoints/webhooks.js` - Webhook API
- E-05: `ghost/core/core/server/services/permissions/can-this.js` - 権限チェック

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 66個のエンドポイントファイルが存在 | E-01 (Glob結果) | ○ |
| C-02 | postsエンドポイントでdocName, browse, read, add, edit, destroyを定義 | E-02 (参照) | ○ |
| C-03 | integrationsエンドポイントでbrowse, read, edit, add, destroyを定義 | E-03 | ○ |
| C-04 | webhooksエンドポイントでadd, edit, destroyを定義 | E-04 | ○ |
| C-05 | permissions: trueで権限チェックを有効化 | E-03, E-04 | ○ |
| C-06 | cacheInvalidate設定がheadersに含まれる | E-03, E-04 | ○ |
| C-07 | validationでdata/optionsのバリデーションを定義 | E-03, E-04 | ○ |
| C-08 | canThis()で権限チェックを実行 | E-05 | ○ |
| C-09 | ロールベースのアクセス制御を実装 | E-05 | ○ |
| C-10 | Staff APIキーでユーザー権限を使用 | E-05 (76-88行目) | ○ |
| C-11 | 401/403/404/422/500のエラーコードを使用 | E-03, E-04 | ○ |
| C-12 | statusCodeでレスポンスコードを指定 | E-03 (104行目), E-04 (23行目) | ○ |
| C-13 | destroyアクションでstatusCode: 204を返す | E-03 (141行目), E-04 (89行目) | ○ |
| C-14 | addアクションでstatusCode: 201を返す | E-03 (104行目), E-04 (23行目) | ○ |
| C-15 | require: trueでリソースが存在しない場合エラー | E-03 (63, 158行目), E-04 (84, 129行目) | ○ |
| C-16 | includeオプションでapi_keys, webhooksをサポート | E-03 (29-32, 55-58行目) | ○ |
| C-17 | permissions.beforeで事前権限チェック | E-04 (42-64, 103-126行目) | ○ |
| C-18 | integration_idでWebhookの所有者を確認 | E-04 (53, 115行目) | ○ |
| C-19 | tpl関数でエラーメッセージをテンプレート化 | E-03, E-04 | ○ |
| C-20 | @tryghost/errorsでエラークラスを使用 | E-03, E-04 | ○ |
| C-21 | 単一リソース操作500ms以内 | **根拠なし** | △ |
| C-22 | 一覧取得1000ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な根拠
  - 候補：パフォーマンステスト結果 / SLA文書 / 要件定義書
- Admin APIキー認証の詳細実装
  - 候補：認証ミドルウェアのソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - エンドポイント構造の確認済み
- 0: 低リスク - 権限チェック機構の確認済み
- 1: 中リスク - パフォーマンス要件の根拠がない
- 0: 低リスク - エラーハンドリングの確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の妥当性を確認
- [ ] Admin APIキー認証の詳細実装を確認
- [ ] すべてのエンドポイントでpermissions設定を確認
- [ ] 管理画面との整合性を確認
