---
generated_at: 2026-01-29 21:55:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：46-カスタムインテグレーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な性能要件の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/models/integration.js` - Integrationモデル定義
- E-02: `ghost/core/core/server/api/endpoints/integrations.js` - APIエンドポイント
- E-03: `ghost/core/core/server/services/integrations/integrations-service.js` - インテグレーションサービス
- E-04: `ghost/core/core/server/data/schema/schema.js` - DBスキーマ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tableName: 'integrations' | E-01 (7行目) | ○ |
| C-02 | relationshipsにapi_keys, webhooksが含まれる | E-01 (12行目) | ○ |
| C-03 | relationshipConfigでeditable: trueを設定 | E-01 (13-20行目) | ○ |
| C-04 | defaults()でtype: 'custom'を設定 | E-01 (27-31行目) | ○ |
| C-05 | onSaving()でスラッグ生成 | E-01 (38-48行目) | ○ |
| C-06 | permissible関数で制限チェック | E-01 (87-99行目) | ○ |
| C-07 | limitService.isLimited('customIntegrations')で制限確認 | E-01 (90行目) | ○ |
| C-08 | browseアクションでfindPageを使用 | E-02 (34-36行目) | ○ |
| C-09 | includeオプションでapi_keys, webhooksをサポート | E-02 (29-32行目) | ○ |
| C-10 | readアクションでrequire: trueを使用 | E-02 (63行目) | ○ |
| C-11 | editアクションでkeyidオプションをサポート | E-02 (86行目) | ○ |
| C-12 | addアクションでname必須 | E-02 (119-121行目) | ○ |
| C-13 | addでContent/Admin APIキーを自動作成 | E-02 (131-135行目) | ○ |
| C-14 | destroyアクションでrequire: trueを使用 | E-02 (158行目) | ○ |
| C-15 | statusCode: 201をaddで使用 | E-02 (104行目) | ○ |
| C-16 | statusCode: 204をdestroyで使用 | E-02 (141行目) | ○ |
| C-17 | IntegrationsServiceでedit処理 | E-03 (14-51行目) | ○ |
| C-18 | keyid指定時にApiKeyModel.refreshSecretを呼び出し | E-03 (26行目) | ○ |
| C-19 | refreshSecret後にwithRelatedで関連取得 | E-03 (28-30行目) | ○ |
| C-20 | integrationsテーブルにtype, name, slug, icon_image, descriptionカラムあり | E-04 (337-352行目) | ○ |
| C-21 | typeのバリデーションでinternal,builtin,custom,coreを許可 | E-04 (339-344行目) | ○ |
| C-22 | actionsCollectCRUD: trueで操作履歴を記録 | E-01 (9行目) | ○ |
| C-23 | actionsResourceType: 'integration'を設定 | E-01 (10行目) | ○ |
| C-24 | api_keys関数でhasMany関係を定義 | E-01 (61-63行目) | ○ |
| C-25 | webhooks関数でhasMany関係を定義 | E-01 (65-67行目) | ○ |
| C-26 | 作成500ms以内、一覧取得200ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な根拠
  - 候補：パフォーマンステスト結果 / SLA文書 / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モデル定義とAPIの整合性を確認済み
- 0: 低リスク - APIキー自動作成の実装を確認済み
- 0: 低リスク - 制限チェックの実装を確認済み
- 1: 中リスク - パフォーマンス要件の根拠がない

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の妥当性を確認
- [ ] カスケード削除が正しく動作するか確認
- [ ] APIキー再生成（refreshSecret）の実装を確認
- [ ] 関連画面（No.58）との整合性を確認
