---
generated_at: 2026-01-29 22:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-Webhook

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、高い信頼性

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/models/webhook.js` - Webhookモデル定義
- E-02: `ghost/core/core/server/api/endpoints/webhooks.js` - APIエンドポイント
- E-03: `ghost/core/core/server/services/webhooks/webhooks-service.js` - Webhookサービス
- E-04: `ghost/core/core/server/services/webhooks/listen.js` - イベントリスナー
- E-05: `ghost/core/core/server/services/webhooks/webhook-trigger.js` - Webhookトリガー
- E-06: `ghost/core/core/server/data/schema/schema.js` - DBスキーマ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tableName: 'webhooks' | E-01 (7行目) | ○ |
| C-02 | defaults()でapi_versionとstatusを設定 | E-01 (12-17行目) | ○ |
| C-03 | findAllByEventでイベントに該当するWebhookを検索 | E-01 (46-52行目) | ○ |
| C-04 | getByEventAndTargetで重複チェック | E-01 (55-75行目) | ○ |
| C-05 | actionsCollectCRUD: trueで操作履歴を記録 | E-01 (9行目) | ○ |
| C-06 | addアクションでwebhooksService.addを呼び出し | E-02 (32-34行目) | ○ |
| C-07 | permissions.beforeで事前権限チェック | E-02 (42-64行目) | ○ |
| C-08 | integration_idでWebhookの所有者を確認 | E-02 (53, 115行目) | ○ |
| C-09 | statusCode: 201をaddで使用 | E-02 (23行目) | ○ |
| C-10 | statusCode: 204をdestroyで使用 | E-02 (89行目) | ○ |
| C-11 | WebhooksServiceで重複チェック | E-03 (18-29行目) | ○ |
| C-12 | 重複がある場合ValidationError | E-03 (25-28行目) | ○ |
| C-13 | 外部キー制約エラーハンドリング | E-03 (35-48行目) | ○ |
| C-14 | WEBHOOKS配列で対応イベントを定義 | E-04 (10-45行目) | ○ |
| C-15 | listen関数で各イベントにリスナーを登録 | E-04 (47-68行目) | ○ |
| C-16 | インポート時はトリガーをスキップ | E-04 (61-63行目) | ○ |
| C-17 | getAll関数でイベントに該当するWebhookを取得 | E-05 (23-49行目) | ○ |
| C-18 | update関数でトリガー結果を記録 | E-05 (51-61行目) | ○ |
| C-19 | destroy関数で410レスポンス時にWebhook削除 | E-05 (64-70行目) | ○ |
| C-20 | trigger関数でHTTPリクエスト送信 | E-05 (98-143行目) | ○ |
| C-21 | Content-Type, Content-Versionヘッダー設定 | E-05 (116-120行目) | ○ |
| C-22 | secretがある場合X-Ghost-Signatureを付与 | E-05 (122-124行目) | ○ |
| C-23 | 署名はsha256でHMAC生成 | E-05 (123行目) | ○ |
| C-24 | タイムアウト2秒を設定 | E-05 (129-131行目) | ○ |
| C-25 | 最大5回リトライ（テスト環境除く） | E-05 (132-134行目) | ○ |
| C-26 | 410レスポンスでWebhook自動削除 | E-05 (83-86行目) | ○ |
| C-27 | onSuccess/onErrorでコールバック処理 | E-05 (73-95行目) | ○ |
| C-28 | autoRefresh: falseで結果更新 | E-05 (58行目) | ○ |
| C-29 | カスタムインテグレーション制限時はinternalのみ許可 | E-05 (24-43行目) | ○ |
| C-30 | webhooksテーブルにevent, target_url, name, secret等のカラムあり | E-06 (353-370行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モデル、API、サービス、トリガーの実装を確認済み
- 0: 低リスク - 署名生成ロジックを確認済み
- 0: 低リスク - リトライ・タイムアウト設定を確認済み
- 0: 低リスク - 権限チェックの実装を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 対応イベント一覧が最新か確認（listen.jsのWEBHOOKS配列）
- [ ] 署名検証のドキュメントが利用者向けに提供されているか確認
- [ ] 410自動削除の動作を実際にテスト
- [ ] 関連画面（No.58）との整合性を確認
