---
generated_at: 2026-01-29 22:05:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-oEmbed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、高い信頼性

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/oembed.js` - APIエンドポイント
- E-02: `ghost/core/core/server/services/oembed/oembed-service.js` - oEmbedサービス実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | permissions: falseで認証不要 | E-01 (11行目) | ○ |
| C-02 | url, typeをdataパラメータで受け取り | E-01 (12-15行目) | ○ |
| C-03 | oembed.fetchOembedDataFromUrlを呼び出し | E-01 (17-20行目) | ○ |
| C-04 | findUrlWithProviderで既知プロバイダー判定 | E-02 (27-51行目) | ○ |
| C-05 | @extractus/oembed-extractorのhasProviderを使用 | E-02 (28行目) | ○ |
| C-06 | URLバリエーション（http/https、www有無）を生成してテスト | E-02 (35-41行目) | ○ |
| C-07 | OEmbedServiceクラスで処理 | E-02 (74-91行目) | ○ |
| C-08 | customProvidersを配列で管理 | E-02 (90行目) | ○ |
| C-09 | registerProviderでカスタムプロバイダー登録 | E-02 (96-98行目) | ○ |
| C-10 | unknownProviderでValidationError | E-02 (103-108行目) | ○ |
| C-11 | knownProviderでextract()を呼び出し | E-02 (113-131行目) | ○ |
| C-12 | 401/403エラー時に認証エラーメッセージ | E-02 (119-124行目) | ○ |
| C-13 | fetchPageHtmlでページHTMLを取得 | E-02 (180-191行目) | ○ |
| C-14 | User-Agentを設定 | E-02 (184-186行目) | ○ |
| C-15 | タイムアウト2000msを設定 | E-02 (187行目) | ○ |
| C-16 | fetchBookmarkDataでmetascraperを使用 | E-02 (283-295行目) | ○ |
| C-17 | metascraper-logo-faviconでアイコン取得 | E-02 (290-293行目) | ○ |
| C-18 | thumbnailとiconを画像処理で保存 | E-02 (327-350行目) | ○ |
| C-19 | 画像処理失敗時はデフォルトアイコンを使用 | E-02 (341-343行目) | ○ |
| C-20 | fetchOembedDataでcheerioを使用 | E-02 (369行目) | ○ |
| C-21 | link rel="alternate" type="application/json+oembed"を検索 | E-02 (374行目) | ○ |
| C-22 | WordPress oEmbedはスキップ | E-02 (382-384行目) | ○ |
| C-23 | 既知フィールドのみ抽出 | E-02 (396-411行目) | ○ |
| C-24 | type=linkはフォールバック | E-02 (415-417行目) | ○ |
| C-25 | YouTubeライブURLを/watch?v=形式に変換 | E-02 (449-455行目) | ○ |
| C-26 | カスタムプロバイダーを優先的にチェック | E-02 (461-468行目) | ○ |
| C-27 | type=bookmark時はブックマークデータを返却 | E-02 (483-485行目) | ○ |
| C-28 | oEmbedデータが取得できない場合はブックマークにフォールバック | E-02 (524-527行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - oEmbedプロバイダー判定ロジックを確認済み
- 0: 低リスク - ブックマークフォールバックの実装を確認済み
- 0: 低リスク - 画像処理のエラーハンドリングを確認済み
- 0: 低リスク - SSRF対策のUser-Agent設定を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] カスタムプロバイダー（Twitter, NFT）の動作を確認
- [ ] 画像保存先のディレクトリ構造を確認
- [ ] 外部フェッチのSSRF対策が十分か確認
- [ ] 関連画面（No.13 エディタ画面）との整合性を確認
