---
generated_at: 2026-01-29 22:10:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-サイト内検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、高い信頼性

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/sodo-search/src/app.js` - Reactアプリメインコンポーネント
- E-02: `apps/sodo-search/src/search-index.js` - 検索インデックス実装
- E-03: `ghost/core/core/server/api/endpoints/search-index-public.js` - Content API検索インデックス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SearchIndexクラスでインデックス管理 | E-02 (59行目) | ○ |
| C-02 | adminUrl, apiKey, dirを初期化時に受け取り | E-02 (60行目) | ○ |
| C-03 | postsIndex, authorsIndex, tagsIndexの3つのインデックス | E-02 (67-98行目) | ○ |
| C-04 | Flexsearch.Documentでインデックス構築 | E-02 (67行目) | ○ |
| C-05 | titleとexcerptをインデックス対象 | E-02 (71-72行目) | ○ |
| C-06 | CJKエンコーダーでCJK対応 | E-02 (3-12, 54-57行目) | ○ |
| C-07 | isCJK関数でCJK文字を判定 | E-02 (14-27行目) | ○ |
| C-08 | tokenizeCjkByCodePointでCJKトークナイズ | E-02 (29-52行目) | ○ |
| C-09 | init関数で3つのインデックスを構築 | E-02 (188-192行目) | ○ |
| C-10 | #fetchPostsでContent APIを呼び出し | E-02 (112-124行目) | ○ |
| C-11 | search関数で3つのインデックスを検索 | E-02 (210-227行目) | ○ |
| C-12 | enrich: trueで詳細データを取得 | E-02 (211-213行目) | ○ |
| C-13 | #normalizeSearchResultで結果を正規化 | E-02 (194-208行目) | ○ |
| C-14 | AppコンポーネントでReactアプリを構成 | E-01 (8行目) | ○ |
| C-15 | componentDidMountで初期化 | E-01 (35-39行目) | ○ |
| C-16 | setupSearchIndexでインデックス構築 | E-01 (79-87行目) | ○ |
| C-17 | indexStarted, indexCompleteで状態管理 | E-01 (80-86行目) | ○ |
| C-18 | handleSearchUrlでハッシュURL対応 | E-01 (157-165行目) | ○ |
| C-19 | addKeyboardShortcutsでCmd/Ctrl+K対応 | E-01 (167-183行目) | ○ |
| C-20 | AppContextでコンテキスト提供 | E-01 (186-210行目) | ○ |
| C-21 | fetchPostsでlimit: 10000を設定 | E-03 (15行目) | ○ |
| C-22 | fetchPostsでvisibilityカラムを取得 | E-03 (18行目) | ○ |
| C-23 | fetchAuthorsでprofile_imageを取得 | E-03 (33行目) | ○ |
| C-24 | fetchTagsでvisibility:publicフィルター | E-03 (49行目) | ○ |
| C-25 | permissions: trueで認証が必要 | E-03 (12, 28, 44行目) | ○ |
| C-26 | RTL言語でtokenize: 'reverse'を使用 | E-02 (61-62行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Flexsearch設定を確認済み
- 0: 低リスク - CJK対応を確認済み
- 0: 低リスク - Content APIとの連携を確認済み
- 0: 低リスク - キーボードショートカットの実装を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CJKトークナイズが実際に機能するか確認
- [ ] 10000件制限が適切か確認
- [ ] キーボードショートカットの競合がないか確認
- [ ] 関連画面（No.100 検索モーダル）との整合性を確認
