---
generated_at: 2026-01-29 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：5-スニペット管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：コード内に明示的な定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/snippet.js`
- E-02: `ghost/core/core/server/api/endpoints/snippets.js`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | snippetsテーブルが存在 | E-01 (8行目) tableName: 'snippets' | ○ |
| C-02 | actionsCollectCRUD: trueで監査ログ記録 | E-01 (10-11行目) | ○ |
| C-03 | mobiledocのURL変換処理がformatOnWriteで実装 | E-01 (14-16行目) | ○ |
| C-04 | lexicalのURL変換処理がformatOnWriteで実装 | E-01 (18-23行目) | ○ |
| C-05 | parseでURL復元処理 | E-01 (28-40行目) | ○ |
| C-06 | formatsToJSONでフォーマット制御 | E-01 (42-54行目) | ○ |
| C-07 | allowedFormats: ['mobiledoc', 'lexical'] | E-01 (63行目) | ○ |
| C-08 | browseアクションでmodels.Snippet.findPageを使用 | E-02 (34行目) | ○ |
| C-09 | readアクションでmodels.Snippet.findOneを使用 | E-02 (50行目) | ○ |
| C-10 | addアクションは201ステータスを返す | E-02 (62行目) | ○ |
| C-11 | addで一意制約違反をキャッチしエラーメッセージを返す | E-02 (72-78行目) | ○ |
| C-12 | destroyアクションは204ステータスを返す | E-02 (111行目) | ○ |
| C-13 | destroyでrequire: trueを指定 | E-02 (127行目) | ○ |
| C-14 | 全アクションでpermissions: true | E-02 (25, 48, 69, 97, 125行目) | ○ |
| C-15 | formatsオプションが利用可能 | E-02 (22, 43, 67, 88行目) | ○ |
| C-16 | formatsのバリデーションでallowedFormatsを使用 | E-02 (28-30行目) | ○ |
| C-17 | mobiledocLibのcardsを使用 | E-01 (15行目) cardTransformers: mobiledocLib.cards | ○ |
| C-18 | lexicalLibのnodesを使用 | E-01 (20行目) nodes: lexicalLib.nodes | ○ |
| C-19 | toJSONでformatsToJSONを呼び出し | E-01 (55-61行目) | ○ |
| C-20 | パフォーマンス要件（100件500ms以内など） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - コード内には明示的なSLAやパフォーマンス目標の定義が見つからなかった
  - 候補：運用ドキュメント / SLA定義書 / パフォーマンステスト仕様書

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: モデル定義の基本構造（コードから明確）
- **0 (低リスク)**: URL変換処理の実装（コードから明確）
- **0 (低リスク)**: APIエンドポイントの構造（コードから直接抽出）
- **0 (低リスク)**: 一意制約違反のエラーハンドリング（コードから明確）
- **1 (中リスク)**: パフォーマンス要件（推測値の可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] スニペット名の一意制約が正しく動作するか確認
- [ ] mobiledoc/lexicalのURL変換が正しく動作するか確認
- [ ] formatsオプションで出力形式が正しく制御されるか確認
- [ ] パフォーマンス要件の数値が実際の運用基準と一致しているか確認
