---
generated_at: 2026-01-29 22:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-検索インデックス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、高い信頼性

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/search-index.js` - Admin API検索インデックス
- E-02: `ghost/core/core/server/api/endpoints/search-index-public.js` - Content API検索インデックス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Admin APIにfetchPosts, fetchPages, fetchTags, fetchUsersの4エンドポイント | E-01 (8, 27, 46, 64行目) | ○ |
| C-02 | Content APIにfetchPosts, fetchAuthors, fetchTagsの3エンドポイント | E-02 (8, 24, 39行目) | ○ |
| C-03 | Admin API fetchPostsでposts.browse権限をチェック | E-01 (12-15行目) | ○ |
| C-04 | Admin API fetchPostsでfilter: 'type:post+status:[draft,published,scheduled,sent]' | E-01 (18行目) | ○ |
| C-05 | Admin API fetchPostsでlimit: '10000' | E-01 (19行目) | ○ |
| C-06 | Admin API fetchPostsでorder: 'updated_at DESC' | E-01 (20行目) | ○ |
| C-07 | Admin API fetchPostsでcolumns: id, uuid, url, title, slug, status, published_at, visibility | E-01 (21行目) | ○ |
| C-08 | Admin API fetchPagesでfilter: 'type:page+status:[draft,published,scheduled]' | E-01 (37行目) | ○ |
| C-09 | Admin API fetchTagsでtags.browse権限をチェック | E-01 (50-53行目) | ○ |
| C-10 | Admin API fetchTagsでmodels.Tag.findPage()を使用 | E-01 (61行目) | ○ |
| C-11 | Admin API fetchUsersでusers.browse権限をチェック | E-01 (68-71行目) | ○ |
| C-12 | Admin API fetchUsersでmodels.User.findPage()を使用 | E-01 (79行目) | ○ |
| C-13 | Content API fetchPostsでpermissions: true | E-02 (12行目) | ○ |
| C-14 | Content API fetchPostsでfilter: 'type:post' | E-02 (15行目) | ○ |
| C-15 | Content API fetchPostsでexcerptカラムを取得 | E-02 (18行目) | ○ |
| C-16 | Content API fetchAuthorsでmodels.Author.findPage()を使用 | E-02 (36行目) | ○ |
| C-17 | Content API fetchTagsでfilter: 'visibility:public' | E-02 (49行目) | ○ |
| C-18 | すべてのエンドポイントでcacheInvalidate: false | E-01 (10, 29, 48, 67行目), E-02 (10, 26, 41行目) | ○ |
| C-19 | Admin API fetchUsersでprofile_imageカラムを取得 | E-01 (76行目) | ○ |
| C-20 | Content API fetchAuthorsでprofile_imageカラムを取得 | E-02 (33行目) | ○ |
| C-21 | postsService.browsePosts()を使用して記事取得 | E-01 (24行目), E-02 (21行目) | ○ |
| C-22 | docName: 'search_index'を設定 | E-01 (7行目), E-02 (7行目) | ○ |
| C-23 | Admin API fetchTagsでcolumns: id, slug, name, url | E-01 (58行目) | ○ |
| C-24 | Content API fetchTagsでcolumns: id, slug, name, url | E-02 (48行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Admin API権限チェックを確認済み
- 0: 低リスク - Content API公開フィルターを確認済み
- 0: 低リスク - データ取得カラムを確認済み
- 0: 低リスク - 最大件数制限を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] limit: 10000が適切か確認（大量データ時のパフォーマンス）
- [ ] Admin APIとContent APIのカラム差異が意図通りか確認
- [ ] models.Authorの実体（Userエイリアス）を確認
- [ ] 関連機能（No.49 サイト内検索）との整合性を確認
