---
generated_at: 2026-01-29 21:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：51-サイト統計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的な数値の根拠がコードから直接確認できない
  2. **キャッシュTTL**: デフォルト値の設定箇所が不明確
  3. **権限制御**: 詳細な権限マッピングの検証推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/api/endpoints/stats.js`
- E-02: `ghost/core/core/server/services/stats/stats-service.js`
- E-03: `ghost/core/core/server/services/stats/members-stats-service.js`
- E-04: `ghost/core/core/server/services/stats/mrr-stats-service.js`
- E-05: `ghost/core/core/server/services/stats/referrers-stats-service.js`
- E-06: `ghost/core/core/server/services/stats/posts-stats-service.js`
- E-07: `apps/stats/src/app.tsx`
- E-08: `apps/stats/src/views/Stats/Overview/overview.tsx`
- E-09: `apps/stats/src/hooks/use-growth-stats.ts`
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 統計サービスは6つのサブサービスで構成される | E-02: stats-service.js 17-24行目 | ○ |
| C-02 | メンバー数は paid/free/comped の3ステータスで管理 | E-03: members-stats-service.js 22-30行目 | ○ |
| C-03 | デフォルト集計期間は91日間 | E-03: members-stats-service.js 43行目 | ○ |
| C-04 | MRRは通貨別に集計される | E-04: mrr-stats-service.js 17-33行目 | ○ |
| C-05 | リファラーソースは正規化マップで統一される | E-05: referrers-stats-service.js 7-105行目 | ○ |
| C-06 | Tinybird連携は設定で有効/無効を切り替え可能 | E-02: stats-service.js 249行目 | ○ |
| C-07 | API権限はmembers:browseとposts:browse | E-01: stats.js 11-13, 81-83行目 | ○ |
| C-08 | 統計データにはキャッシュが適用される | E-01: stats.js 17, 41, 62行目 | ○ |
| C-09 | 日付範囲はgetDateBoundaries関数で計算 | E-06: posts-stats-service.js 105行目 | ○ |
| C-10 | ニュースレター統計は開封率・クリック率を含む | E-06: posts-stats-service.js 743-746行目 | ○ |
| C-11 | 投稿統計はmembers_created_eventsを参照 | E-06: posts-stats-service.js 402-409行目 | ○ |
| C-12 | フロントエンドはReact + Viteで構築 | E-07: app.tsx（React構文）、CLAUDE.md記載 | ○ |
| C-13 | 概要画面でvisitors/members/MRRのKPIを表示 | E-08: overview.tsx 204-213行目 | ○ |
| C-14 | 成長統計フックはuseMemberCountHistoryを使用 | E-09: use-growth-stats.ts 201-205行目 | ○ |
| C-15 | MRR履歴取得はuseMrrHistoryフックを使用 | E-09: use-growth-stats.ts 207-211行目 | ○ |
| C-16 | 通貨シンボルはgetSymbol関数で取得 | E-09: use-growth-stats.ts 338-340行目 | ○ |
| C-17 | 無効なorderフィールドでBadRequestError | E-06: posts-stats-service.js 107-111行目 | ○ |
| C-18 | 将来日付のデータは除外される | E-03: members-stats-service.js 129-131行目 | ○ |
| C-19 | メンバー数はSELECT + GROUP BYで取得 | E-03: members-stats-service.js 17-20行目 | ○ |
| C-20 | MRRデルタはmembers_paid_subscription_eventsから取得 | E-04: mrr-stats-service.js 45-53行目 | ○ |
| C-21 | リファラー統計は90日間が対象 | E-05: referrers-stats-service.js 178, 195行目 | ○ |
| C-22 | 訪問者データはTinybird api_kpisエンドポイントから取得 | E-08: overview.tsx 91-95行目 | ○ |
| C-23 | StatsErrorBoundaryでエラーハンドリング | E-07: app.tsx 21行目 | ○ |
| C-24 | GlobalDataProviderで設定を共有 | E-07: app.tsx 22行目 | ○ |
| C-25 | パフォーマンス要件3秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコードから直接確認できない
  - 候補：運用ドキュメント / SLO定義書 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: データ構造の定義（JSDoc型定義で明確に文書化済み）
- 0: API権限の設定（コードで明示的に定義済み）
- 1: キャッシュ戦略の詳細（実装はあるがTTL等の詳細設定は要確認）
- 1: Tinybird連携時のエラーハンドリング（フォールバック動作の詳細確認推奨）
- 2: パフォーマンス要件（コードベースからの根拠確認不可）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限設定が実際のGhostロールマッピングと一致しているか確認
- [ ] キャッシュTTLのデフォルト値と設定方法を確認
- [ ] Tinybird連携無効時のフォールバック動作を検証
- [ ] パフォーマンス要件の根拠となるドキュメントを確認
- [ ] ソース正規化マップの網羅性を確認（新規プラットフォーム追加時の対応）
