---
generated_at: 2026-01-29 21:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：52-記事分析

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的な数値の根拠がコードから直接確認できない
  2. **権限ロール要件**: Editor以上の記述は推測を含む
  3. **email_onlyリダイレクト動作**: 条件の詳細確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/stats.js`
- E-02: `ghost/core/core/server/services/stats/posts-stats-service.js`
- E-03: `apps/posts/src/views/PostAnalytics/Overview/overview.tsx`
- E-04: `apps/posts/src/hooks/use-post-referrers.ts`
- E-05: `apps/posts/src/hooks/use-post-newsletter-stats.ts`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 投稿別訪問者数はTinybird api_kpisで取得 | E-03: overview.tsx 55-59行目 | ○ |
| C-02 | 成長統計はpostGrowthStatsAPIで取得 | E-04: use-post-referrers.ts 8行目 | ○ |
| C-03 | リファラー統計はpostReferrersAPIで取得 | E-04: use-post-referrers.ts 6行目 | ○ |
| C-04 | ニュースレター統計はpost.emailから取得 | E-05: use-post-newsletter-stats.ts 41-46行目 | ○ |
| C-05 | フィードバックはcount.positive/negative_feedbackで取得 | E-05: use-post-newsletter-stats.ts 19-22行目 | ○ |
| C-06 | API権限はposts:browse | E-01: stats.js 341-343, 374-376行目 | ○ |
| C-07 | 無料メンバーは登録したが有料化しなかったメンバー | E-02: posts-stats-service.js 402-409行目 | ○ |
| C-08 | 有料メンバーは有料コンバージョン発生メンバー | E-02: posts-stats-service.js 412-415行目 | ○ |
| C-09 | MRRはmrr_deltaの合計で計算 | E-02: posts-stats-service.js 417-424行目 | ○ |
| C-10 | ソース正規化はnormalizeSource関数で実施 | E-02: posts-stats-service.js 367行目 | ○ |
| C-11 | 開封率はopened_count/email_countで計算 | E-05: use-post-newsletter-stats.ts 44行目 | ○ |
| C-12 | クリック率はclicks/email_countで計算 | E-05: use-post-newsletter-stats.ts 45行目 | ○ |
| C-13 | 平均開封率は各ニュースレターの合計/件数 | E-05: use-post-newsletter-stats.ts 154-155行目 | ○ |
| C-14 | email_only投稿はWeb統計非表示 | E-03: overview.tsx 96行目 | ○ |
| C-15 | Web分析無効時はGrowthタブにリダイレクト | E-03: overview.tsx 99-103行目 | ○ |
| C-16 | 通貨シンボルはgetSymbol関数で取得 | E-04: use-post-referrers.ts 36, 48行目 | ○ |
| C-17 | 最高MRR通貨を選択して表示 | E-04: use-post-referrers.ts 31-45行目 | ○ |
| C-18 | トップリンクはuseTopLinksフックで取得 | E-05: use-post-newsletter-stats.ts 131-135行目 | ○ |
| C-19 | 基本統計とクリック統計は分離取得 | E-05: use-post-newsletter-stats.ts 75-95行目 | ○ |
| C-20 | postIdはURLパラメータから取得 | E-03: overview.tsx 19行目（useGlobalData経由） | ○ |
| C-21 | チャート範囲は公開日から自動計算 | E-03: overview.tsx 25-31行目 | ○ |
| C-22 | パフォーマンス要件2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコードから直接確認できない
  - 候補：運用ドキュメント / SLO定義書 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: データ取得ロジック（コードで明確に実装済み）
- 0: 計算式の定義（コードで明示的に定義済み）
- 1: email_only判定ロジック（admin-x-frameworkのユーティリティに依存）
- 1: Tinybird連携時のフォールバック（動作確認推奨）
- 2: パフォーマンス要件（コードベースからの根拠確認不可）

## 6) レビュアーチェックリスト（最小）
- [ ] postReferrers APIの返却形式を確認
- [ ] email_only判定ロジックの動作を確認
- [ ] Tinybird無効時のUI表示を確認
- [ ] フィードバック統計の取得タイミングを確認
- [ ] パフォーマンス要件の根拠となるドキュメントを確認
