---
generated_at: 2026-01-29 21:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-メンバー分析

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にコードベースからの根拠が確認できました

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/stats.js`
- E-02: `ghost/core/core/server/services/stats/members-stats-service.js`
- E-03: `ghost/core/core/server/services/stats/subscription-stats-service.js`
- E-04: `apps/stats/src/hooks/use-growth-stats.ts`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト集計期間は91日間 | E-02: members-stats-service.js 43行目 | ○ |
| C-02 | メンバー数はpaid/free/compedの3ステータス | E-02: members-stats-service.js 22-30行目 | ○ |
| C-03 | fetchAllStatusDeltasでデルタ取得 | E-02: members-stats-service.js 39-69行目 | ○ |
| C-04 | SQL CASEでpaid_subscribed計算 | E-02: members-stats-service.js 48-51行目 | ○ |
| C-05 | SQL CASEでpaid_canceled計算 | E-02: members-stats-service.js 52-55行目 | ○ |
| C-06 | startDate指定時はComplete Range生成 | E-02: members-stats-service.js 87-88行目 | ○ |
| C-07 | startDate未指定時はSparse Range生成 | E-02: members-stats-service.js 92行目 | ○ |
| C-08 | 将来日付のデータは除外 | E-02: members-stats-service.js 129-131行目 | ○ |
| C-09 | 累計がマイナスにならないようMath.max(0)で補正 | E-02: members-stats-service.js 135-137, 226-228行目 | ○ |
| C-10 | API権限はmembers:browse | E-01: stats.js 11-13行目 | ○ |
| C-11 | サブスクリプション履歴はTier/Cadence別 | E-03: subscription-stats-service.js 89-92行目 | ○ |
| C-12 | positive_deltaはcreated/reactivated/active | E-03: subscription-stats-service.js 94-101行目 | ○ |
| C-13 | negative_deltaはcanceled/expired/inactive | E-03: subscription-stats-service.js 102-108行目 | ○ |
| C-14 | fetchSubscriptionCountsでTier/Cadence別カウント | E-03: subscription-stats-service.js 132-148行目 | ○ |
| C-15 | フロントエンドはuseGrowthStatsフック使用 | E-04: use-growth-stats.ts 192行目 | ○ |
| C-16 | useMemberCountHistoryでAPI呼び出し | E-04: use-growth-stats.ts 201-205行目 | ○ |
| C-17 | useSubscriptionStatsでサブスクリプション統計取得 | E-04: use-growth-stats.ts 214行目 | ○ |
| C-18 | 通貨シンボルはgetSymbol関数で取得 | E-04: use-growth-stats.ts 338-340行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: メンバーステータス定義（コードで明確に定義）
- 0: 集計ロジック（SQLクエリで明確に実装）
- 0: 日付範囲処理（Complete/Sparse両方のロジック確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] サブスクリプションイベントのtype値が正しく網羅されているか確認
- [ ] Tier/Cadence集計のJOIN条件を確認
- [ ] フロントエンドでの通貨選択ロジックを確認
