---
generated_at: 2026-01-29 21:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-リンクトラッキング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にコードベースからの根拠が確認できました

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/link-tracking/link-click-tracking-service.js`
- E-02: `ghost/core/core/server/services/link-tracking/click-event.js`
- E-03: `ghost/core/core/server/services/link-tracking/post-link.js`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | addTrackingToUrlでURL変換 | E-01: 215-219行目 | ○ |
| C-02 | addRedirectToUrlでリダイレクト作成 | E-01: 191-206行目 | ○ |
| C-03 | PostLinkで投稿との関連付け | E-01: 199-203行目 | ○ |
| C-04 | RedirectEvent購読でクリック処理 | E-01: 221-234行目 | ○ |
| C-05 | UUIDがない場合はスキップ | E-01: 223-226行目 | ○ |
| C-06 | LinkClickで記録 | E-01: 228-232行目 | ○ |
| C-07 | サイト内URLにattribution追加 | E-01: 138-143行目 | ○ |
| C-08 | refパラメータを引き継ぎ | E-01: 133-135行目 | ○ |
| C-09 | bulkEditでリンク更新 | E-01: 178-185行目 | ○ |
| C-10 | updateLinkアクションのみサポート | E-01: 179-184行目 | ○ |
| C-11 | getLinksでリンク一覧取得 | E-01: 94-98行目 | ○ |
| C-12 | parseLinkFilterでフィルター解析 | E-01: 107-127行目 | ○ |
| C-13 | BadRequestErrorで無効フィルター通知 | E-01: 113-115, 122-125行目 | ○ |
| C-14 | IncorrectUsageErrorで未対応アクション通知 | E-01: 182-184行目 | ○ |
| C-15 | initでsubscribe呼び出し | E-01: 81-87行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: イベント購読ロジック（コードで明確に実装）
- 0: リダイレクト作成処理（手順が明確）
- 1: トランザクション処理（bulkEdit時の整合性確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] RedirectEventの発行元を確認
- [ ] 大量リンク更新時のパフォーマンスを確認
- [ ] メンバーUUIDの取得方法を確認
