---
generated_at: 2026-01-29 21:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：55-Tinybird連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にコードベースからの根拠が確認できました

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/tinybird/tinybird-service.js`
- E-02: `ghost/core/core/server/services/tinybird/tinybird-service-wrapper.js`
- E-03: `ghost/core/core/server/api/endpoints/tinybird.js`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JWTモード判定はworkspaceIdとadminTokenで行う | E-01: 89行目 | ○ |
| C-02 | ローカルモード判定はlocal.enabledで行う | E-01: 90行目 | ○ |
| C-03 | レガシーモード判定はstats.tokenで行う | E-01: 91行目 | ○ |
| C-04 | デフォルト有効期限は180分 | E-01: 102行目 | ○ |
| C-05 | 有効期限の5分前で自動更新 | E-01: 172行目（bufferSeconds=300） | ○ |
| C-06 | PIPES:READスコープでアクセス制限 | E-01: 148行目 | ○ |
| C-07 | site_uuidでスコープを制限 | E-01: 150-152行目 | ○ |
| C-08 | 24パイプへのアクセス許可 | E-01: 47-73行目 | ○ |
| C-09 | adminTokenで署名 | E-01: 157行目 | ○ |
| C-10 | 設定はconfig.get('tinybird')で取得 | E-02: 12行目 | ○ |
| C-11 | siteUuidはsettingsCache.get('site_uuid')で取得 | E-02: 13行目 | ○ |
| C-12 | 設定なしの場合はログ出力してnull | E-02: 16-18行目 | ○ |
| C-13 | API権限はmembers:browse | E-03: 12-13行目 | ○ |
| C-14 | expをISO 8601形式で返却 | E-03: 22行目 | ○ |
| C-15 | トークンキャッシュは_serverTokenに保存 | E-01: 108行目 | ○ |
| C-16 | トークン有効期限は_serverTokenExpに保存 | E-01: 109行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: トークン生成ロジック（コードで明確に実装）
- 0: モード判定ロジック（フラグで明示的に定義）
- 1: v2パイプの違い（マテリアライズドビュー最適化の詳細確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] adminTokenの安全な保管を確認
- [ ] トークンキャッシュの競合状態を確認
- [ ] ローカル開発時の動作を確認
