---
generated_at: 2026-01-29 22:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-オーディエンスフィードバック

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にコードベースからの根拠が確認できました

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/audience-feedback/audience-feedback-controller.js`
- E-02: `ghost/core/core/server/services/audience-feedback/audience-feedback-service.js`
- E-03: `ghost/core/core/server/services/audience-feedback/feedback-repository.js`
- E-04: `ghost/core/core/server/services/audience-feedback/feedback.js`
- E-05: `ghost/core/core/server/api/endpoints/feedback-members.js`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スコアは0または1のみ許可 | E-01: 50行目 | ○ |
| C-02 | 投稿存在確認を実行 | E-01: 58-63行目 | ○ |
| C-03 | メンバー認証確認を実行 | E-01: 35-43行目 | ○ |
| C-04 | 既存フィードバックを検索 | E-01: 65行目 | ○ |
| C-05 | スコアが同じ場合は保存しない | E-01: 67-70行目 | ○ |
| C-06 | スコアが異なる場合は更新 | E-01: 71-73行目 | ○ |
| C-07 | 新規の場合は作成 | E-01: 76-82行目 | ○ |
| C-08 | browse権限でposts:browseを使用 | E-05: 28-30行目 | ○ |
| C-09 | add権限はfalse（Members API） | E-05: 52行目 | ○ |
| C-10 | buildLinkでフィードバックURL生成 | E-02: 22-31行目 | ○ |
| C-11 | 404の場合はbaseURLにフォールバック | E-02: 25-27行目 | ○ |
| C-12 | URLハッシュにuuidとkeyを含む | E-02: 29行目 | ○ |
| C-13 | FeedbackクラスにObjectID使用 | E-04: 1, 14-16行目 | ○ |
| C-14 | リポジトリでMemberFeedback.add呼び出し | E-03: 28-35行目 | ○ |
| C-15 | リポジトリでMemberFeedback.edit呼び出し | E-03: 37-43行目 | ○ |
| C-16 | getForPostでページネーション対応 | E-03: 68-98行目 | ○ |
| C-17 | withRelated: memberでメンバー情報取得 | E-03: 79行目 | ○ |
| C-18 | browseでlimit/page/scoreオプション対応 | E-01: 86-95行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: スコアバリデーション（コードで明確に実装）
- 0: 重複更新回避ロジック（条件分岐で明示的に実装）
- 1: メールリンクのkey署名検証（フロントエンド側の検証確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] メールリンクのkey署名検証ロジックを確認
- [ ] フィードバック送信のレート制限を確認
- [ ] フィードバック統計のキャッシュ戦略を確認
