---
generated_at: 2026-01-29 22:05:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：57-ActivityPub

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にコードベースからの根拠が確認できました

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/activitypub/activity-pub-service-wrapper.js`
- E-02: `ghost/core/core/server/services/activitypub/activity-pub-service.ts`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IdentityTokenService依存性チェック | E-01: 21-24行目 | ○ |
| C-02 | social_web_enabledで有効化判定 | E-01: 36行目 | ○ |
| C-03 | enable()/disable()の呼び分け | E-01: 38-44行目 | ○ |
| C-04 | settings.labs.editedイベント購読 | E-01: 49行目 | ○ |
| C-05 | settings.social_web.editedイベント購読 | E-01: 50行目 | ○ |
| C-06 | settings.is_private.editedイベント購読 | E-01: 51行目 | ○ |
| C-07 | 4つのWebhookイベント定義 | E-02: 28-53行目 | ○ |
| C-08 | APIバージョンv5.100.0 | E-02: 32行目 | ○ |
| C-09 | checkWebhookStateで状態確認 | E-02: 56-80行目 | ○ |
| C-10 | Webhook数の一致確認 | E-02: 64-67行目 | ○ |
| C-11 | event, target_url, secretの一致確認 | E-02: 70-71行目 | ○ |
| C-12 | 不一致時は全削除して再作成 | E-02: 157-178行目 | ○ |
| C-13 | ghost-activitypub統合を検索 | E-02: 130-135行目 | ○ |
| C-14 | Ownerユーザーのトークン取得 | E-02: 196-204行目 | ○ |
| C-15 | disableSiteでDELETEリクエスト | E-02: 181-194行目 | ○ |
| C-16 | removeWebhooksで既存削除 | E-02: 110-127行目 | ○ |
| C-17 | ObjectIDでWebhook ID生成 | E-02: 165行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: Webhook管理ロジック（コードで明確に実装）
- 0: イベント購読（明示的に登録）
- 1: ActivityPub Serviceとの通信（外部サービス依存）

## 6) レビュアーチェックリスト（最小）
- [ ] ActivityPub Serviceのエンドポイント可用性を確認
- [ ] Webhook秘密鍵のローテーション方針を確認
- [ ] プライベートモード変更時の動作を確認
