---
generated_at: 2026-01-29 22:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-Webmention

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にコードベースからの根拠が確認できました

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/mentions/mention.js`
- E-02: `ghost/core/core/server/services/mentions/mention-controller.js`
- E-03: `ghost/core/core/server/services/mentions/mentions-api.js`
- E-04: `ghost/core/core/server/services/mentions/mention-sending-service.js`
- E-05: `ghost/core/core/server/services/mentions/service.js`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | receive()でジョブキューに追加 | E-02: 125行目 | ○ |
| C-02 | processWebmentionで既存検索 | E-03: 271-274行目 | ○ |
| C-03 | pageExistsでターゲット存在確認 | E-03: 187-197行目 | ○ |
| C-04 | getByURLでリソース特定 | E-03: 200行目 | ○ |
| C-05 | webmentionMetadata.fetchでメタデータ取得 | E-03: 203行目 | ○ |
| C-06 | verify()でa/img/video要素検索 | E-01: 50行目 | ○ |
| C-07 | text/htmlでcheerio使用 | E-01: 46-63行目 | ○ |
| C-08 | application/jsonでJSON.parse使用 | E-01: 65-83行目 | ○ |
| C-09 | 検証済みでリンク削除時deleted=true | E-01: 53-56行目, 73-76行目 | ○ |
| C-10 | MentionCreatedEvent発行 | E-01: 324行目 | ○ |
| C-11 | listen()でpost.published等イベント購読 | E-04: 35-40行目 | ○ |
| C-12 | sendForPostでHTML変更チェック | E-04: 57-60行目 | ○ |
| C-13 | 新規/削除リンクのみ処理 | E-04: 126-145行目 | ○ |
| C-14 | 自サイトリンク除外 | E-04: 197-200行目 | ○ |
| C-15 | is_private時は無効化 | E-05: 103行目 | ○ |
| C-16 | send()でPOSTリクエスト | E-04: 91-105行目 | ○ |
| C-17 | source_is_ghost=trueフラグ | E-04: 95行目 | ○ |
| C-18 | タイムアウト15秒 | E-04: 100行目 | ○ |
| C-19 | リトライ3回 | E-04: 103行目 | ○ |
| C-20 | メタデータ最大2000文字 | E-01: 163, 168, 170, 176行目 | ○ |
| C-21 | browse()でpage/limit/order対応 | E-02: 61-94行目 | ○ |
| C-22 | unique=trueでソース重複排除 | E-02: 83-86行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 検証ロジック（コードで明確に実装）
- 0: イベント購読（明示的に登録）
- 1: 外部リクエストのエラーハンドリング（ログ出力のみで継続）

## 6) レビュアーチェックリスト（最小）
- [ ] Webmentionエンドポイント検出ロジックを確認
- [ ] 外部サイトへのリクエストレート制限を確認
- [ ] メタデータ取得時のセキュリティ（SSRF対策）を確認
