---
generated_at: 2026-01-29 22:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-アウトボックス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にコードベースからの根拠が確認できました

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/outbox/index.js`
- E-02: `ghost/core/core/server/services/outbox/jobs/lib/process-outbox.js`
- E-03: `ghost/core/core/server/services/outbox/jobs/lib/process-entries.js`
- E-04: `ghost/core/core/server/services/outbox/handlers/member-created.js`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | scheduleOutboxJob()でジョブ登録 | E-01: 16行目 | ○ |
| C-02 | StartOutboxProcessingEvent購読 | E-01: 18-20行目 | ○ |
| C-03 | 処理中フラグで排他制御 | E-01: 26-28行目 | ○ |
| C-04 | labs.welcomeEmailsフラグチェック | E-02: 45-47行目 | ○ |
| C-05 | fetchPendingEntriesでPENDINGエントリ取得 | E-02: 10-39行目 | ○ |
| C-06 | forUpdate()でロック取得 | E-02: 24行目 | ○ |
| C-07 | 取得時にPROCESSING更新 | E-02: 29-34行目 | ○ |
| C-08 | MAX_ENTRIES_PER_JOBで上限制御 | E-02: 61行目 | ○ |
| C-09 | BATCH_SIZEでバッチサイズ制御 | E-02: 63行目 | ○ |
| C-10 | バッチ処理速度をログ出力 | E-02: 73, 78行目 | ○ |
| C-11 | EVENT_HANDLERSでハンドラーマッピング | E-03: 7-9行目 | ○ |
| C-12 | ハンドラー未定義時は失敗記録 | E-03: 45-49行目 | ○ |
| C-13 | 成功時はdeleteProcessedEntry | E-03: 69行目 | ○ |
| C-14 | 削除失敗時はCOMPLETED更新 | E-03: 72行目 | ○ |
| C-15 | リトライ超過でFAILED | E-03: 19行目 | ○ |
| C-16 | エラーメッセージ2000文字制限 | E-03: 20行目 | ○ |
| C-17 | memberWelcomeEmailService.api.send呼び出し | E-04: 10行目 | ○ |
| C-18 | AutomatedEmailRecipient.add()で送信記録 | E-04: 25-31行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: リトライロジック（コードで明確に実装）
- 0: 排他制御（フラグで明示的に実装）
- 1: ジョブスケジュール間隔（constants.jsの確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] MAX_RETRIESの値を確認
- [ ] ジョブスケジュール間隔を確認
- [ ] BATCH_SIZE/MAX_ENTRIES_PER_JOBの値を確認
