---
generated_at: 2026-01-29 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-記事リビジョン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/lib/post-revisions.ts`
- E-02: `ghost/core/core/server/models/post-revision.js`
- E-03: `ghost/core/core/server/models/post.js`
- E-04: `ghost/core/core/server/data/schema/schema.js`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 最大リビジョン数は25件 | E-03 (38行目) POST_REVISIONS_COUNT = 25, E-03 (910行目) | ○ |
| C-02 | バックグラウンド保存間隔は10分 | E-03 (39行目) POST_REVISIONS_INTERVAL_MS = 10 * 60 * 1000 | ○ |
| C-03 | 初回保存時はinitial_revisionとして作成 | E-01 (58-60行目) | ○ |
| C-04 | 公開時はpublishedとして作成 | E-01 (67-70行目) | ○ |
| C-05 | 非公開化時はunpublishedとして作成 | E-01 (62-65行目) | ○ |
| C-06 | 明示的保存時はexplicit_saveとして作成 | E-01 (80-82行目) | ○ |
| C-07 | 10分経過後はbackground_saveとして作成 | E-01 (84-86行目) | ○ |
| C-08 | lexical, title, feature_image, custom_excerptの変更を検出 | E-01 (73-77行目) | ○ |
| C-09 | max_revisionsを超える場合は古いものを削除 | E-01 (108-109行目) | ○ |
| C-10 | post_revisionsテーブルに保存 | E-02 (5行目), E-04 (402-416行目) | ○ |
| C-11 | authorリレーションがある | E-02 (7-8行目) | ○ |
| C-12 | created_at_tsで時間経過を計算 | E-01 (84行目), E-04 (406行目) | ○ |
| C-13 | reasonフィールドに作成理由を保存 | E-01 (98行目), E-04 (411行目) | ○ |
| C-14 | post_statusフィールドがある | E-01 (12行目, 127行目), E-04 (410行目) | ○ |
| C-15 | PostRevisionsクラスで実装 | E-01 (45行目) | ○ |
| C-16 | shouldGenerateRevision()で判定 | E-01 (55-89行目) | ○ |
| C-17 | getRevisions()でリビジョン配列を更新 | E-01 (91-113行目) | ○ |
| C-18 | convertPostLikeToRevision()で変換 | E-01 (115-129行目) | ○ |
| C-19 | PostモデルのonSavingフックで呼び出し | E-03 (906-951行目) | ○ |
| C-20 | removeAuthorFromRevisions()で著者削除時の処理 | E-01 (132-154行目) | ○ |
| C-21 | orderDefaultRawでcreated_at_ts降順 | E-02 (32-34行目) | ○ |
| C-22 | toJSONでauthor_idを削除 | E-02 (36-42行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に対して根拠が確認できた。不足情報なし。

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: リビジョン生成判定ロジック（TypeScriptで明確に実装）
- **0 (低リスク)**: 最大件数と保存間隔の設定（定数として明示）
- **0 (低リスク)**: データベーススキーマ（明確に定義）
- **0 (低リスク)**: Postモデルからの呼び出し（コードから明確）

## 6) レビュアーチェックリスト（最小）
- [ ] リビジョン生成判定の各条件が正しく動作するか確認
- [ ] 25件制限が正しく適用されるか確認
- [ ] 10分間隔のバックグラウンド保存が正しく動作するか確認
- [ ] 著者削除時のauthor_id nullification が正しく動作するか確認
