---
generated_at: 2026-01-29 22:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-サイトレコメンデーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にコードベースからの根拠が確認できました

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/recommendations/recommendation-service-wrapper.js`
- E-02: `ghost/core/core/server/services/recommendations/service/recommendation-service.ts`
- E-03: `ghost/core/core/server/services/recommendations/service/recommendation-controller.ts`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 初期化時にupdateWellknown呼び出し | E-02: 56-57行目 | ○ |
| C-02 | 起動2-7分後にメタデータ一括更新 | E-02: 61-69行目 | ○ |
| C-03 | URL重複チェック | E-02: 127-132行目 | ○ |
| C-04 | addRecommendation後にWebmention送信 | E-02: 141行目 | ○ |
| C-05 | deleteRecommendation後もWebmention送信 | E-02: 235行目 | ○ |
| C-06 | updateRecommendationsEnabledSetting呼び出し | E-02: 138, 232行目 | ○ |
| C-07 | 既存タイトルがある場合は上書きしない | E-02: 188行目 | ○ |
| C-08 | trackClicked()でClickEvent保存 | E-02: 263-266行目 | ○ |
| C-09 | trackSubscribed()でSubscribeEvent保存 | E-02: 268-271行目 | ○ |
| C-10 | readRecommendationByUrlでURL検索 | E-02: 273-280行目 | ○ |
| C-11 | browseでpage/limit/filter/order対応 | E-03: 145-169行目 | ○ |
| C-12 | デフォルトlimit=5 | E-03: 149行目 | ○ |
| C-13 | withRelatedでcount.clicks/subscribers対応 | E-03: 14-17, 150-154行目 | ○ |
| C-14 | デフォルトorderはcreatedAt desc | E-03: 114-119行目 | ○ |
| C-15 | trackClickedはメンバー認証オプション | E-03: 172行目（#optionalAuthMember） | ○ |
| C-16 | trackSubscribedはメンバー認証必須 | E-03: 182行目（#authMember） | ○ |
| C-17 | 認証なしでUnauthorizedError | E-03: 197-199行目 | ○ |
| C-18 | serializeでcount.clicks/subscribers返却 | E-03: 234-237行目 | ○ |
| C-19 | MentionCreatedEvent購読 | E-01: 173行目 | ○ |
| C-20 | recommendations.jsonパス判定 | E-01: 156-160行目 | ○ |
| C-21 | sendRecommendationEmail呼び出し | E-01: 177行目 | ○ |
| C-22 | mentionSendingService.sendAllでWebmention送信 | E-02: 101-106行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: CRUD操作（コードで明確に実装）
- 0: トラッキング（イベント保存で明示的に実装）
- 1: メタデータ取得の信頼性（外部リクエスト依存）

## 6) レビュアーチェックリスト（最小）
- [ ] Well-known JSONの形式を確認
- [ ] メタデータ取得時のSSRF対策を確認
- [ ] 受信レコメンデーションメールのテンプレートを確認
